/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.tile;

import net.minecraft.nbt.NBTTagCompound;
import redgear.core.tile.TileEntityGeneric;

public abstract class TileEntityMachine
extends TileEntityGeneric {
    private final int idleRate;
    private int idle = 0;
    private int energyRate = 0;
    private int standby = 0;
    protected int workTotal = 0;
    protected int work = 0;

    public TileEntityMachine(int idleRate) {
        this.idleRate = idleRate;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.isClient()) {
            return;
        }
        if (this.standby > 0) {
            --this.standby;
            return;
        }
        boolean check = false;
        if (this.idle-- <= 0) {
            int add;
            this.idle = this.idleRate;
            check |= this.doPreWork();
            if (this.work == 0 && (add = this.checkWork()) > 0) {
                this.addWork(add);
                check = true;
            }
        }
        if (this.work > 0 && this.tryUseEnergy(this.energyRate)) {
            check |= this.doWork();
            if (--this.work <= 0) {
                this.workTotal = 0;
                check |= this.doPostWork();
            }
        }
        if (check) {
            this.forceSync();
        }
    }

    public int getWork() {
        return this.work;
    }

    public void addWork(int work) {
        this.work += work;
        this.workTotal = work;
    }

    public int getWorkTotal() {
        return this.workTotal;
    }

    public void setWorkTotal(int workTotal) {
        this.workTotal = workTotal;
    }

    public void setEnergyRate(int energyRate) {
        this.energyRate = energyRate;
    }

    public int getIdle() {
        return this.idle;
    }

    public void setIdle(int idle) {
        this.idle = idle;
    }

    public int getStandby() {
        return this.standby;
    }

    public void setStandby(int ticks) {
        this.standby = ticks;
    }

    protected void stopWork() {
        this.workTotal = 0;
        this.work = 0;
    }

    protected abstract boolean doPreWork();

    protected abstract int checkWork();

    protected abstract boolean doWork();

    protected abstract boolean tryUseEnergy(int var1);

    protected abstract boolean doPostWork();

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("idle", this.idle);
        tag.func_74772_a("energyRate", (long)this.energyRate);
        tag.func_74768_a("work", this.work);
        tag.func_74768_a("workTotal", this.workTotal);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.idle = tag.func_74762_e("idle");
        this.energyRate = tag.func_74762_e("energyRate");
        this.work = tag.func_74762_e("work");
        this.workTotal = tag.func_74762_e("workTotal");
    }
}

