/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.render.gui.element;

import cofh.api.energy.IEnergyStorage;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import redgear.core.render.GuiBase;
import redgear.core.render.RenderHelper;
import redgear.core.render.gui.element.ElementBase;

public class ElementEnergyStored
extends ElementBase {
    public static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("Energy.png");
    public static final int DEFAULT_SCALE = 42;
    protected IEnergyStorage storage;

    public ElementEnergyStored(GuiBase gui, int posX, int posY, IEnergyStorage storage) {
        super(gui, posX, posY);
        this.storage = storage;
        this.texture = DEFAULT_TEXTURE;
        this.sizeX = 16;
        this.sizeY = 42;
        this.texW = 32;
        this.texH = 64;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        RenderHelper.bindTexture(this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY);
        int qty = this.getScaled();
        this.drawTexturedModalRect(this.posX, this.posY + 42 - qty, 16, 42 - qty, this.sizeX, qty);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.storage.getMaxEnergyStored() < 0) {
            list.add("Infinite RF");
        } else {
            list.add("" + this.storage.getEnergyStored() + " / " + this.storage.getMaxEnergyStored() + " RF");
        }
    }

    int getScaled() {
        if (this.storage.getMaxEnergyStored() < 0) {
            return this.sizeY;
        }
        return this.storage.getEnergyStored() * this.sizeY / this.storage.getMaxEnergyStored();
    }
}

