/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.recipes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redgear.core.recipes.Level;
import redgear.core.recipes.Replacement;

public class RecipeMap {
    List<String> craftMap;
    Map<Character, Object> charMap;

    public RecipeMap(String[] craftMap, Level level) {
        this.craftMap = new ArrayList<String>(craftMap.length - 1);
        this.charMap = new HashMap<Character, Object>(level.action.size());
        for (String add : craftMap) {
            this.craftMap.add(add);
        }
        this.replace(level);
    }

    public RecipeMap(String ... craftMap) {
        this.craftMap = new ArrayList<String>(craftMap.length - 1);
        this.charMap = new HashMap<Character, Object>();
        for (String add : craftMap) {
            this.craftMap.add(add);
        }
    }

    public RecipeMap(String[] craftMap, Object ... charMap) {
        this.craftMap = new ArrayList<String>(craftMap.length - 1);
        this.charMap = new HashMap<Character, Object>(charMap.length / 2);
        for (String add : craftMap) {
            this.craftMap.add(add);
        }
        this.replace(new Level(true, charMap));
    }

    public void replace(Level bit) {
        if (bit.requirement) {
            for (Replacement replace : bit.action) {
                if (replace.value == null) continue;
                this.charMap.put(Character.valueOf(replace.key), replace.value);
            }
        }
    }

    public Object[] outputShaped() {
        ArrayList<Object> out = new ArrayList<Object>();
        out.addAll(this.craftMap);
        for (Map.Entry<Character, Object> row : this.charMap.entrySet()) {
            out.add(row.getKey());
            out.add(row.getValue());
        }
        return out.toArray();
    }

    public Object[] outputShapeless() {
        ArrayList<Object> out = new ArrayList<Object>();
        out.addAll(this.craftMap);
        for (Map.Entry<Character, Object> row : this.charMap.entrySet()) {
            out.add(row.getValue());
        }
        return out.toArray();
    }
}

