/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.mod;

import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;
import redgear.core.api.util.ReflectionHelper;
import redgear.core.asm.RedGearCore;
import redgear.core.mod.IPlugin;
import redgear.core.util.SimpleItem;
import redgear.core.util.StringHelper;

public abstract class ModUtils {
    public Logger myLogger;
    public boolean isDebugMode;
    private Configuration config;
    private File configFile;
    private boolean isConfigLoaded;
    private final List<IPlugin> plugins = new LinkedList<IPlugin>();
    public final String modId;
    public final String modName;
    public final String modVersion;
    public final String modDepend;

    public ModUtils() {
        String modId = "Unknown";
        String modName = "Unknown";
        String modVersion = "Unknown";
        String modDepend = "Unknown";
        for (Annotation a : this.getClass().getDeclaredAnnotations()) {
            if (!(a instanceof Mod)) continue;
            Mod m = (Mod)a;
            modId = m.modid();
            modName = m.name();
            modVersion = m.version();
            modDepend = m.dependencies();
            break;
        }
        this.modId = modId;
        this.modName = modName;
        this.modVersion = modVersion;
        this.modDepend = modDepend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PreInitialization(FMLPreInitializationEvent event) {
        this.configFile = StringHelper.parseConfigFile(event.getModConfigurationDirectory());
        this.config = new Configuration(this.configFile);
        this.myLogger = event.getModLog();
        this.isConfigLoaded = false;
        this.isDebugMode = this.getBoolean("debugMode", false);
        try {
            try {
                this.PreInit(event);
            }
            catch (Throwable e) {
                this.throwFatal("PreInitialization", e);
            }
            for (IPlugin bit : this.plugins) {
                try {
                    if (!bit.shouldRun(this, LoaderState.ModState.PREINITIALIZED)) continue;
                    bit.preInit(this);
                }
                catch (Throwable e) {
                    this.throwPlugin("PreInitialization", bit, e);
                }
            }
        }
        finally {
            this.saveConfig();
        }
    }

    protected abstract void PreInit(FMLPreInitializationEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Initialization(FMLInitializationEvent event) {
        try {
            try {
                this.Init(event);
            }
            catch (Throwable e) {
                this.throwFatal("Initialization", e);
            }
            for (IPlugin bit : this.plugins) {
                try {
                    if (!bit.shouldRun(this, LoaderState.ModState.INITIALIZED)) continue;
                    bit.Init(this);
                }
                catch (Throwable e) {
                    this.throwPlugin("Initialization", bit, e);
                }
            }
        }
        finally {
            this.saveConfig();
        }
    }

    protected abstract void Init(FMLInitializationEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PostInitialization(FMLPostInitializationEvent event) {
        try {
            try {
                this.PostInit(event);
            }
            catch (Throwable e) {
                this.throwFatal("PostInitialization", e);
            }
            for (IPlugin bit : this.plugins) {
                try {
                    if (!bit.shouldRun(this, LoaderState.ModState.POSTINITIALIZED)) continue;
                    bit.postInit(this);
                }
                catch (Throwable e) {
                    this.throwPlugin("PostInitialization", bit, e);
                }
            }
        }
        finally {
            this.saveConfig();
        }
        this.plugins.clear();
    }

    protected abstract void PostInit(FMLPostInitializationEvent var1);

    public void addPlugin(IPlugin add) {
        if (add != null) {
            this.plugins.add(add);
        }
    }

    public void addPlugin(IPlugin add, Side side) {
        if (side == this.getSide()) {
            this.addPlugin(add);
        }
    }

    public void addPlugin(String add, Side side, Object[] ... params) {
        Object obj;
        if (side == this.getSide() && (obj = ReflectionHelper.constructObjectNullFail(add, (Object[])params)) instanceof IPlugin) {
            this.addPlugin((IPlugin)obj);
        }
    }

    public File getConfigDirectory() {
        return this.configFile.getParentFile();
    }

    public void loadConfig() {
        if (!this.isConfigLoaded) {
            this.config.load();
            this.isConfigLoaded = true;
        }
    }

    public void saveConfig() {
        if (this.isConfigLoaded && this.config.hasChanged()) {
            this.config.save();
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void set(String category, String key, String value) {
        if (value == null || value.length() < 1) {
            return;
        }
        String old = this.getString(category, key, null, value);
        if (old != value) {
            this.config.getCategory(category).get(key).set(value);
        }
    }

    public void set(String category, String key, double value) {
        double old = this.getDouble(category, key, value);
        if (old != value) {
            this.config.getCategory(category).get(key).set(value);
        }
    }

    public void set(String category, String key, int value) {
        int old = this.getInt(category, key, value);
        if (old != value) {
            this.config.getCategory(category).get(key).set(value);
        }
    }

    public void set(String category, String key, boolean value) {
        boolean old = this.getBoolean(category, key, value);
        if (old != value) {
            this.config.getCategory(category).get(key).set(value);
        }
    }

    public String getString(String name) {
        return this.getString(name, "");
    }

    public String getString(String category, String name) {
        return this.getString(category, name, "");
    }

    public String getString(String category, String name, String comment) {
        return this.getString(category, name, comment, "");
    }

    public String getString(String category, String name, String comment, String Default) {
        this.loadConfig();
        Property prop = this.config.get(category, name, Default);
        if (prop == null) {
            return Default;
        }
        if (comment != null && comment.length() > 0) {
            prop.comment = comment;
        }
        return prop.getString();
    }

    public double getDouble(String name, double Default) {
        return this.getDouble("general", name, Default);
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public double getDouble(String category, String name) {
        return this.getDouble(category, name, 0.0);
    }

    public double getDouble(String category, String name, double Default) {
        return this.getDouble(category, name, null, Default);
    }

    public double getDouble(String category, String name, String comment) {
        return this.getDouble(category, name, comment, 0.0);
    }

    public double getDouble(String category, String name, String comment, double Default) {
        this.loadConfig();
        Property prop = this.config.get(category, name, Default);
        if (comment != null) {
            prop.comment = comment;
        }
        return prop.getDouble(Default);
    }

    public int getInt(String name, int Default) {
        return this.getInt("general", name, Default);
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String category, String name) {
        return this.getInt(category, name, 0);
    }

    public int getInt(String category, String name, int Default) {
        return this.getInt(category, name, null, Default);
    }

    public int getInt(String category, String name, String comment) {
        return this.getInt(category, name, comment, 0);
    }

    public int getInt(String category, String name, String comment, int Default) {
        this.loadConfig();
        Property prop = this.config.get(category, name, Default);
        if (comment != null) {
            prop.comment = comment;
        }
        return prop.getInt(Default);
    }

    public boolean getBoolean(String name, boolean Default) {
        return this.getBoolean("general", name, Default);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, true);
    }

    public boolean getBoolean(String category, String name) {
        return this.getBoolean(category, name, true);
    }

    public boolean getBoolean(String category, String name, boolean Default) {
        return this.getBoolean(category, name, null, Default);
    }

    public boolean getBoolean(String category, String name, String comment) {
        return this.getBoolean(category, name, comment, true);
    }

    public boolean getBoolean(String category, String name, String comment, boolean Default) {
        this.loadConfig();
        Property prop = this.config.get(category, name, Default);
        if (comment != null) {
            prop.comment = comment;
        }
        return prop.getBoolean(Default);
    }

    public void addSmelting(SimpleItem input, SimpleItem result) {
        this.addSmelting(input.getStack(), result.getStack());
    }

    public void addSmelting(Item input, ItemStack result) {
        this.addSmelting(new ItemStack(input), result);
    }

    public void addSmelting(Block input, ItemStack result) {
        this.addSmelting(new ItemStack(input), result);
    }

    public void addSmelting(ItemStack input, ItemStack result) {
        this.addSmelting(input, result, 0.0f);
    }

    public void addSmelting(ItemStack input, ItemStack result, float exp) {
        FurnaceRecipes.func_77602_a().func_151394_a(input, result, exp);
    }

    public void registerOre(String name, SimpleItem ore) {
        this.registerOre(name, ore.getStack());
    }

    public void registerOre(String name, ItemStack ore) {
        OreDictionary.registerOre((String)name, (ItemStack)ore);
    }

    public boolean inOreDict(String ore) {
        return !OreDictionary.getOres((String)ore).isEmpty();
    }

    public void logDebug(String message) {
        if (this.isDebugMode) {
            this.myLogger.info("DEBUG: " + message);
        }
    }

    public void logDebug(Object ... message) {
        if (this.isDebugMode) {
            this.logDebug(StringHelper.concat(message));
        }
    }

    public void logDebug(String message, Throwable e) {
        if (this.isDebugMode) {
            this.logWarning("DEBUG: " + message, e);
        }
    }

    public void logWarning(String message, Throwable e) {
        this.myLogger.warn(message);
        e.printStackTrace();
    }

    public Side getSide() {
        return RedGearCore.proxy.getSide();
    }

    public boolean isServer() {
        return this.getSide() == Side.SERVER;
    }

    public boolean isClient() {
        return this.getSide() == Side.CLIENT;
    }

    private void throwFatal(String phase, Throwable e) {
        throw new RuntimeException(StringHelper.concat(this.modName, " crashed during the ", phase, " phase. "), e);
    }

    private void throwPlugin(String phase, IPlugin plug, Throwable e) {
        if (plug.isRequired()) {
            throw new RuntimeException(StringHelper.concat(this.modName, " crashed during the ", phase, " phase while attempting to run plugin: ", plug.getName(), "."), e);
        }
        this.logWarning(StringHelper.concat("Plugin ", plug.getName(), " failed during the ", phase, "."), e);
    }
}

