/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.imc;

import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.HashMap;
import java.util.Map;
import redgear.core.imc.IMCMessageHandler;

public class IMCEventHandler {
    Map<String, IMCMessageHandler> handlers = new HashMap<String, IMCMessageHandler>();

    public void addHandler(String key, IMCMessageHandler handler) {
        this.handlers.put(key, handler);
    }

    public void handle(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            IMCMessageHandler handler = this.handlers.get(message.key);
            if (handler == null) continue;
            if (message.isStringMessage()) {
                handler.handle(message.getStringValue());
            }
            if (message.isItemStackMessage()) {
                handler.handle(message.getItemStackValue());
            }
            if (!message.isNBTMessage()) continue;
            handler.handle(message.getNBTValue());
        }
    }
}

