/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.fluids;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import redgear.core.asm.RedGearCore;
import redgear.core.util.StringHelper;

public class FluidUtil {
    public static ItemStack getEmptyContainer(ItemStack filledContainer) {
        FluidContainerRegistry.FluidContainerData[] data;
        if (!FluidContainerRegistry.isFilledContainer((ItemStack)filledContainer)) {
            return null;
        }
        for (FluidContainerRegistry.FluidContainerData point : data = FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!point.filledContainer.func_77969_a(filledContainer)) continue;
            return point.emptyContainer;
        }
        return null;
    }

    public static int getContainerCapacity(FluidStack fluid, ItemStack container) {
        if (FluidContainerRegistry.isFilledContainer((ItemStack)container)) {
            return FluidContainerRegistry.getFluidForFilledItem((ItemStack)container).amount;
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)container)) {
            return FluidContainerRegistry.getFluidForFilledItem((ItemStack)FluidContainerRegistry.fillFluidContainer((FluidStack)fluid, (ItemStack)container)).amount;
        }
        return 0;
    }

    public static int getContainerCapacity(ItemStack container) {
        return FluidUtil.getContainerCapacity(new FluidStack(FluidRegistry.WATER, Integer.MAX_VALUE), container);
    }

    public static Fluid createFluid(String name) {
        return FluidUtil.createFluid(name, name);
    }

    public static Fluid createFluid(String fluidName, String iconName) {
        Fluid fluid = new Fluid(fluidName);
        fluid.setUnlocalizedName(StringHelper.parseUnLocalName(fluidName));
        return FluidUtil.createFluid(fluid, iconName);
    }

    public static Fluid createFluid(Fluid fluid, String iconName) {
        if (!FluidRegistry.registerFluid((Fluid)fluid)) {
            fluid = FluidRegistry.getFluid((String)fluid.getName());
        } else {
            RedGearCore.proxy.addFluid(StringHelper.getModId() + ":" + iconName, fluid);
        }
        return fluid;
    }
}

