/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.world;

import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import redgear.core.api.item.ISimpleItem;
import redgear.core.util.SimpleItem;

public class Location
extends ChunkPosition {
    public Location(int x, int y, int z) {
        super(x, y, z);
    }

    public Location(ChunkPosition pos) {
        this(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
    }

    public Location(TileEntity tile) {
        this(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public Location(MovingObjectPosition pos) {
        this(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
    }

    public Location(Vec3 vector) {
        super(vector);
    }

    public int getX() {
        return this.field_151329_a;
    }

    public int getY() {
        return this.field_151327_b;
    }

    public int getZ() {
        return this.field_151328_c;
    }

    protected Location create(int x, int y, int z) {
        return new Location(x, y, z);
    }

    public Location copy() {
        return new Location(this);
    }

    public boolean check(IBlockAccess world, ISimpleItem block) {
        if (block == null) {
            return true;
        }
        if (block.equals(Blocks.field_150350_a) && this.isAir(world)) {
            return true;
        }
        return block.equals(new SimpleItem(this, world));
    }

    public boolean check(IBlockAccess world, ISimpleItem block, ChunkPosition relative) {
        return this.copy().translate(relative).check(world, block);
    }

    public boolean check(IBlockAccess world, Collection<ISimpleItem> blocks) {
        for (ISimpleItem block : blocks) {
            if (!this.check(world, block)) continue;
            return true;
        }
        return false;
    }

    public boolean check(IBlockAccess world, Collection<ISimpleItem> blocks, ChunkPosition relative) {
        return this.copy().translate(relative).check(world, blocks);
    }

    public boolean check(IBlockAccess world, Class<? extends TileEntity> classes, ChunkPosition relative) {
        return this.copy().translate(relative).check(world, classes);
    }

    public boolean check(IBlockAccess world, Class<? extends TileEntity> type) {
        return type.isInstance(this.getTile(world));
    }

    public void placeBlock(World world, ISimpleItem block) {
        world.func_147465_d(this.field_151329_a, this.field_151327_b, this.field_151328_c, block.getBlock(), block.getMeta(), 3);
    }

    public void placeBlock(World world, ISimpleItem block, ChunkPosition relative) {
        this.copy().translate(relative).placeBlock(world, block);
    }

    public boolean placeBlock(World world, ISimpleItem block, ISimpleItem target) {
        if (this.check((IBlockAccess)world, target)) {
            this.placeBlock(world, block);
            return true;
        }
        return false;
    }

    public boolean placeBlock(World world, ISimpleItem item, ISimpleItem target, ChunkPosition relative) {
        return this.copy().translate(relative).placeBlock(world, item, target);
    }

    public boolean placeBlock(World world, ISimpleItem block, Collection<ISimpleItem> targets) {
        for (ISimpleItem it : targets) {
            if (!this.placeBlock(world, block, it)) continue;
            return true;
        }
        return false;
    }

    public boolean placeBlock(World world, ISimpleItem item, Collection<ISimpleItem> targets, ChunkPosition relative) {
        return this.copy().translate(relative).placeBlock(world, item, targets);
    }

    public Block getBlock(IBlockAccess world) {
        return world.func_147439_a(this.field_151329_a, this.field_151327_b, this.field_151328_c);
    }

    public int getBlockMeta(IBlockAccess world) {
        return world.func_72805_g(this.field_151329_a, this.field_151327_b, this.field_151328_c);
    }

    public TileEntity getTile(IBlockAccess world) {
        return world.func_147438_o(this.field_151329_a, this.field_151327_b, this.field_151328_c);
    }

    public Material getMaterial(IBlockAccess world) {
        return this.getBlock(world).func_149688_o();
    }

    public boolean isAir(IBlockAccess world) {
        return world.func_147437_c(this.field_151329_a, this.field_151327_b, this.field_151328_c);
    }

    public void setAir(World world) {
        this.placeBlock(world, new SimpleItem(Blocks.field_150350_a));
    }

    public boolean isSideSolid(IBlockAccess world, ForgeDirection side) {
        return world.isSideSolid(this.field_151329_a, this.field_151327_b, this.field_151328_c, side, false);
    }

    public Location rotate(ForgeDirection direction, int degrees) {
        if ((degrees = Math.abs(degrees) % 4) == 0) {
            return this.copy();
        }
        switch (direction) {
            case DOWN: {
                return this.rotateY(this, (degrees + 2) % 4);
            }
            case UP: {
                return this.rotateY(this, degrees);
            }
            case NORTH: {
                return this.rotateZ(this, (degrees + 2) % 4);
            }
            case SOUTH: {
                return this.rotateZ(this, degrees);
            }
            case WEST: {
                return this.rotateX(this, (degrees + 2) % 4);
            }
            case EAST: {
                return this.rotateX(this, degrees);
            }
        }
        return this.copy();
    }

    public Location reflect(ForgeDirection direction) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return this.reflectY();
            }
            case NORTH: 
            case SOUTH: {
                return this.reflectZ();
            }
            case WEST: 
            case EAST: {
                return this.reflectX();
            }
        }
        return this.copy();
    }

    private Location rotateX(Location loc, int degrees) {
        if (degrees > 1) {
            loc = this.rotateX(loc, --degrees);
        }
        return this.create(loc.field_151329_a, loc.field_151328_c, -loc.field_151327_b);
    }

    private Location rotateY(Location loc, int degrees) {
        if (degrees > 1) {
            loc = this.rotateY(loc, --degrees);
        }
        return this.create(-loc.field_151328_c, loc.field_151327_b, loc.field_151329_a);
    }

    private Location rotateZ(Location loc, int degrees) {
        if (degrees > 1) {
            loc = this.rotateZ(loc, --degrees);
        }
        return this.create(loc.field_151327_b, -loc.field_151329_a, loc.field_151328_c);
    }

    private Location reflectX() {
        return this.create(-this.field_151329_a, this.field_151327_b, this.field_151328_c);
    }

    private Location reflectY() {
        return this.create(this.field_151329_a, -this.field_151327_b, this.field_151328_c);
    }

    private Location reflectZ() {
        return this.create(this.field_151329_a, this.field_151327_b, -this.field_151328_c);
    }

    public Location translate(ChunkPosition other) {
        return this.create(this.field_151329_a + other.field_151329_a, this.field_151327_b + other.field_151327_b, this.field_151328_c + other.field_151328_c);
    }

    public Location translate(int direction, int amount) {
        return this.translate(ForgeDirection.getOrientation((int)direction), amount);
    }

    public Location translate(int x, int y, int z) {
        return this.translate(this.create(x, y, z));
    }

    public Location translate(ForgeDirection direction, int amount) {
        return this.translate(direction.offsetX * amount, direction.offsetY * amount, direction.offsetZ * amount);
    }

    public String toString() {
        return "Location [x=" + this.field_151329_a + ", y=" + this.field_151327_b + ", z=" + this.field_151328_c + "]";
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("x", this.field_151329_a);
        tag.func_74768_a("y", this.field_151327_b);
        tag.func_74768_a("z", this.field_151328_c);
    }

    public void writeToNBT(NBTTagCompound tag, String name) {
        NBTTagCompound subTag = new NBTTagCompound();
        this.writeToNBT(subTag);
        tag.func_74782_a(name, (NBTBase)subTag);
    }

    public Location(NBTTagCompound tag) {
        this(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public Location(NBTTagCompound tag, String name) {
        this(tag.func_74775_l(name));
    }
}

