/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.world;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import redgear.core.world.Location;

public class ChunkCoordinate {
    public int x;
    public int z;

    public ChunkCoordinate(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public ChunkCoordinate(ChunkCoordinate other) {
        this(other.x, other.z);
    }

    public ChunkCoordinate(Location loc) {
        this(loc.field_151329_a >> 4, loc.field_151328_c >> 4);
    }

    public ChunkCoordinate(Chunk chunk) {
        this(chunk.field_76635_g, chunk.field_76647_h);
    }

    public ChunkCoordinate translate(ChunkCoordinate relative) {
        this.x += relative.x;
        this.z += relative.z;
        return this;
    }

    public ChunkCoordinate translate(int x, int z) {
        return this.translate(new ChunkCoordinate(x, z));
    }

    public ChunkCoordinate translaste(int direction, int amount) {
        return this.translate(ForgeDirection.getOrientation((int)direction), amount);
    }

    public ChunkCoordinate translate(ForgeDirection direction, int amount) {
        return this.translate(direction.offsetX * amount, direction.offsetZ * amount);
    }

    public boolean checkExists(World world) {
        return world.func_72863_F().func_73149_a(this.x, this.z);
    }

    public Chunk getChunk(World world) {
        return world.func_72938_d(this.x, this.z);
    }

    public int hashCode() {
        return this.hash(this.hash(1, this.x), this.z);
    }

    protected int hash(int seed, int value) {
        return seed * 31 + value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChunkCoordinate) {
            return this.equals((ChunkCoordinate)obj);
        }
        return false;
    }

    public boolean equals(ChunkCoordinate other) {
        return this.x == other.x && this.z == other.z;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("z", this.z);
    }

    public ChunkCoordinate(NBTTagCompound tag) {
        this(tag.func_74762_e("x"), tag.func_74762_e("z"));
    }
}

