/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;

@SideOnly(value=Side.CLIENT)
public class CoreIconRegistry {
    private static CoreIconRegistry instance;
    private final HashMap<String, IIcon> icons = new HashMap();
    private final HashMap<Fluid, String> fluids = new HashMap();
    private static final String flow = "_flow";
    private static final String still = "_still";

    private CoreIconRegistry() {
    }

    static CoreIconRegistry init() {
        if (instance == null) {
            instance = new CoreIconRegistry();
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
        return instance;
    }

    @SubscribeEvent
    public void registerIcons(TextureStitchEvent.Pre event) {
        TextureMap reg = event.map;
        if (reg.func_130086_a() == 0) {
            for (Map.Entry<String, IIcon> set : this.icons.entrySet()) {
                set.setValue(reg.func_94245_a(set.getKey()));
            }
        }
    }

    @SubscribeEvent
    public void registerFluidIcons(TextureStitchEvent.Post event) {
        for (Map.Entry<Fluid, String> set : this.fluids.entrySet()) {
            set.getKey().setIcons(this.getIcon(set.getValue() + still), this.getIcon(set.getValue() + flow));
        }
    }

    void addIcon(String name) {
        this.icons.put(name, null);
    }

    IIcon getIcon(String name) {
        return this.icons.get(name);
    }

    void addFluid(String iconName, Fluid fluid) {
        this.addIcon(iconName + flow);
        this.addIcon(iconName + still);
        this.fluids.put(fluid, iconName);
    }
}

