/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.mod;

import java.io.File;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import redgear.core.asm.CoreLoadingPlugin;
import redgear.core.mod.CoreModConfiguration;
import redgear.core.util.StringHelper;

public class CoreModUtils {
    public Logger myLogger;
    public boolean isDebugMode;
    private final CoreModConfiguration config;
    private boolean isConfigLoaded;

    public CoreModUtils(String modId) {
        this(StringHelper.parseConfigFile(new File(CoreLoadingPlugin.mcLocation, "config"), modId), LogManager.getLogger((String)modId));
    }

    public CoreModUtils(File configFile, Logger logger) {
        this.config = new CoreModConfiguration(configFile, this);
        this.myLogger = logger;
        this.isConfigLoaded = false;
        this.isDebugMode = this.getBoolean("debugMode", false);
        this.saveConfig();
    }

    public void loadConfig() {
        if (!this.isConfigLoaded) {
            this.config.load();
            this.isConfigLoaded = true;
        }
    }

    public void saveConfig() {
        if (this.isConfigLoaded && this.config.hasChanged()) {
            this.config.save();
            this.isConfigLoaded = false;
        }
    }

    public boolean getBoolean(String name, boolean Default) {
        this.loadConfig();
        return this.config.getBoolean(name, Default);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, true);
    }

    public int getInt(String name, int Default) {
        this.loadConfig();
        return this.config.getInt(name, Default);
    }

    public void logDebug(String message) {
        if (this.isDebugMode) {
            this.myLogger.log(Level.INFO, "DEBUG: " + message);
        }
    }

    public void logDebug(String message, Exception e) {
        if (this.isDebugMode) {
            this.myLogger.log(Level.WARN, "DEBUG: " + message);
            e.printStackTrace();
        }
    }
}

