/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class InvSlot
extends Slot {
    private ItemStack contents;
    private int stackLimit = 64;
    private boolean playerPressure = false;
    private int pressure = 0;

    public InvSlot(IInventory inventory, int x, int y) {
        super(inventory, inventory.func_70302_i_(), x, y);
    }

    public ItemStack addStack(ItemStack stack) {
        return this.addStack(stack, true);
    }

    public ItemStack addStack(ItemStack stack, boolean all) {
        return this.addStack(stack, all, true);
    }

    public ItemStack addStack(ItemStack stack, boolean all, boolean override) {
        if (this.canAddStack(stack, all, override)) {
            if (this.contents == null) {
                if (stack != null) {
                    this.contents = stack.func_77946_l();
                }
                return null;
            }
            int canFit = this.contents.func_77976_d() - this.contents.field_77994_a;
            this.contents.field_77994_a += Math.min(canFit, stack.field_77994_a);
            if (canFit >= stack.field_77994_a) {
                return null;
            }
            stack.field_77994_a -= canFit;
            return stack;
        }
        return stack;
    }

    public boolean canAddStack(ItemStack stack) {
        return this.canAddStack(stack, true);
    }

    public boolean canAddStack(ItemStack stack, boolean all) {
        return this.canAddStack(stack, all, true);
    }

    public boolean canAddStack(ItemStack stack, boolean all, boolean override) {
        if (this.contents == null) {
            return this.stackAllowed(stack);
        }
        if (stack == null) {
            return false;
        }
        return !(!this.contents.func_77985_e() || !stack.func_77969_a(this.contents) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.contents) || !this.stackAllowed(stack) || this.contents.field_77994_a >= this.contents.func_77976_d() || !override && this.pressure > 0 || all && this.contents.field_77994_a + stack.field_77994_a > this.contents.func_77976_d());
    }

    public boolean stackAllowed(ItemStack stack) {
        return true;
    }

    public boolean canExtract() {
        return this.pressure >= 0;
    }

    public InvSlot setPressure(int pressure) {
        this.pressure = pressure;
        return this;
    }

    public InvSlot setPlayerPressure(boolean playerPressure) {
        this.playerPressure = playerPressure;
        return this;
    }

    public InvSlot setStackLimit(int stackLimit) {
        this.stackLimit = stackLimit;
        return this;
    }

    public ItemStack func_75211_c() {
        return this.contents;
    }

    public void func_75215_d(ItemStack par1ItemStack) {
        this.contents = par1ItemStack;
        this.func_75218_e();
    }

    public void func_75218_e() {
        super.func_75218_e();
        if (this.contents != null && this.contents.field_77994_a == 0) {
            this.contents = null;
        }
    }

    public int func_75219_a() {
        return this.stackLimit;
    }

    public ItemStack func_75209_a(int amount) {
        return this.decrStackSize(amount, true);
    }

    public ItemStack decrStackSize(int amount, boolean override) {
        ItemStack temp = this.contents;
        if (temp != null && (override || this.pressure >= 0)) {
            if (temp.field_77994_a <= amount) {
                this.contents = null;
            } else {
                temp = temp.func_77979_a(amount);
                if (temp.field_77994_a == 0) {
                    this.contents = null;
                }
            }
        }
        return temp;
    }

    public boolean func_82869_a(EntityPlayer par1EntityPlayer) {
        return this.playerPressure ? this.pressure >= 0 : true;
    }

    public boolean func_75214_a(ItemStack par1ItemStack) {
        return this.playerPressure ? this.pressure <= 0 : true;
    }
}

