/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.energy.thermal;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import redgear.core.energy.thermal.IThermalContainerItem;
import redgear.core.energy.thermal.IThermalHandler;
import redgear.core.energy.thermal.IThermalStorage;
import redgear.core.energy.thermal.ThermalMaterial;

public class HeatStack {
    protected final float specificHeat;
    protected final float conductivity;
    protected final int heat;

    public HeatStack(IThermalStorage thermal) {
        this.specificHeat = thermal.getSpecificHeat();
        this.conductivity = thermal.getConductivity();
        this.heat = thermal.getHeat();
    }

    public HeatStack(IThermalHandler thermal, ForgeDirection side) {
        this.specificHeat = thermal.getSpecificHeat();
        this.conductivity = thermal.getConductivity(side);
        this.heat = thermal.getHeat();
    }

    public HeatStack(IThermalContainerItem thermal, ItemStack stack) {
        this.specificHeat = thermal.getSpecificHeat(stack);
        this.conductivity = thermal.getConductivity(stack);
        this.heat = thermal.getHeat(stack);
    }

    public HeatStack(Block block) {
        this.specificHeat = ThermalMaterial.getSpecificHeat(block);
        this.conductivity = ThermalMaterial.getConductivity(block);
        this.heat = ThermalMaterial.getHeat(block);
    }

    public static HeatStack create(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IThermalHandler) {
            return new HeatStack((IThermalHandler)tile, side);
        }
        return new HeatStack(world.func_147439_a(x, y, z));
    }

    public float getSpecificHeat() {
        return this.specificHeat;
    }

    public float getConductivity() {
        return this.conductivity;
    }

    public int getHeat() {
        return this.heat;
    }

    public float getTemperature() {
        return (float)this.heat / this.specificHeat;
    }

    public int shareHeat(HeatStack other) {
        if (other == null) {
            return 0;
        }
        return (int)((other.getTemperature() - this.getTemperature()) / (other.getConductivity() * this.getConductivity()));
    }
}

