/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.block;

import buildcraft.api.tools.IToolWrench;
import cofh.api.block.IBlockDebug;
import cofh.api.block.IBlockInfo;
import cofh.api.block.IDismantleable;
import cofh.api.tileentity.IRedstoneCache;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import redgear.core.api.tile.IBucketableTank;
import redgear.core.api.tile.IDismantleableTile;
import redgear.core.api.tile.IFacedTile;
import redgear.core.api.tile.IRedstoneCachePrecise;
import redgear.core.api.tile.IRedstoneEmiter;
import redgear.core.api.tile.ITileDebug;
import redgear.core.api.tile.ITileInfo;
import redgear.core.api.tile.IWrenchableTile;
import redgear.core.asm.RedGearCore;
import redgear.core.block.IDifferentDrop;
import redgear.core.block.MetaBlock;
import redgear.core.block.SubTile;
import redgear.core.world.WorldLocation;

public class MetaTile
extends MetaBlock<SubTile>
implements ITileEntityProvider,
IBlockDebug,
IBlockInfo,
IDismantleable {
    public MetaTile(Material par2Material, String name) {
        super(par2Material, name);
        this.field_149758_A = true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (this.indexCheck(meta)) {
            return ((SubTile)this.getMetaBlock(meta)).createTile();
        }
        return ((SubTile)this.getMetaBlock(0)).createTile();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float f, float g, float t) {
        SubTile block = (SubTile)this.getMetaBlock(world.func_72805_g(x, y, z));
        if (block != null) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() != null) {
                TileEntity tile;
                if (this.holdingWrench(player)) {
                    TileEntity tile2 = world.func_147438_o(x, y, z);
                    if (tile2 instanceof IWrenchableTile) {
                        IWrenchableTile wrenchable = (IWrenchableTile)tile2;
                        boolean test = player.func_70093_af() ? wrenchable.wrenchedShift(player, ForgeDirection.getOrientation((int)side)) : wrenchable.wrenched(player, ForgeDirection.getOrientation((int)side));
                        if (!test) {
                            return true;
                        }
                    }
                } else if (FluidContainerRegistry.isContainer((ItemStack)player.func_70694_bm()) && (tile = world.func_147438_o(x, y, z)) instanceof IBucketableTank && ((IBucketableTank)tile).bucket(player, player.field_71071_by.field_70461_c, player.func_70694_bm())) {
                    return true;
                }
            }
            if (block.hasGui() && !player.func_70093_af()) {
                player.openGui((Object)RedGearCore.inst, block.guiId(), world, x, y, z);
                return true;
            }
        }
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (entity == null) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IFacedTile) {
            ((IFacedTile)tile).onBlockPlacedBy(world, x, y, z, entity, stack);
        }
        this.checkRedstone(world, x, y, z);
    }

    @Override
    public int func_149643_k(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            for (Map.Entry test : this.blocks.entrySet()) {
                if (!((SubTile)test.getValue()).createTile().getClass().equals(tile.getClass())) continue;
                return (Integer)test.getKey();
            }
        }
        return 0;
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        SubTile called = (SubTile)this.getMetaBlock(meta);
        WorldLocation loc = new WorldLocation(x, y, z, world);
        if (called instanceof IDifferentDrop) {
            return ((IDifferentDrop)((Object)called)).getDrops(loc, meta, fortune);
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(1);
        ret.add(new ItemStack((Block)this, 1, meta));
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (this.indexCheck(meta)) {
            return ((SubTile)this.getMetaBlock(meta)).getBlockTexture(world, x, y, z, side);
        }
        return ((SubTile)this.getMetaBlock(0)).getBlockTexture(world, x, y, z, side);
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkRedstone(world, x, y, z);
    }

    private void checkRedstone(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IRedstoneCachePrecise) {
            ((IRedstoneCachePrecise)tile).setPower(world.func_94572_D(x, y, z));
        } else if (tile instanceof IRedstoneCache) {
            ((IRedstoneCache)tile).setPowered(world.func_72864_z(x, y, z));
        }
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IRedstoneEmiter) {
            return ((IRedstoneEmiter)tile).getRedstoneSignal(ForgeDirection.getOrientation((int)side).getOpposite());
        }
        return 0;
    }

    @Override
    public void debugBlock(IBlockAccess world, int x, int y, int z, ForgeDirection side, EntityPlayer player) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof ITileDebug) {
            ((ITileDebug)tile).debugBlock(side, player);
        }
    }

    @Override
    public void getBlockInfo(IBlockAccess world, int x, int y, int z, ForgeDirection side, EntityPlayer player, List<String> info, boolean debug) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof ITileInfo) {
            ((ITileInfo)tile).getBlockInfo(side, player, info, debug);
        }
    }

    @Override
    public ItemStack dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnBlock) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IDismantleableTile) {
            NBTTagCompound tag = new NBTTagCompound();
            ItemStack stack = ((IDismantleableTile)tile).dismantleBlock(player, tag, this.holdingWrench(player), player.func_70093_af());
            if (stack == null) {
                stack = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
            }
            if (!tag.func_82582_d()) {
                stack.field_77990_d = tag;
            }
            if (returnBlock) {
                player.field_71071_by.func_70441_a(stack);
            } else {
                this.func_149642_a(world, x, y, z, stack);
            }
            world.func_147468_f(x, y, z);
            return stack;
        }
        return null;
    }

    @Override
    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IDismantleableTile) {
            return ((IDismantleableTile)tile).canDismantle(player, this.holdingWrench(player), player.func_70093_af());
        }
        return false;
    }

    protected boolean holdingWrench(EntityPlayer player) {
        return player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IToolWrench;
    }
}

