/*
 * Decompiled with CFR 0.152.
 */
package com.samtrion.smoothbedrock.worldgeneration;

import com.samtrion.smoothbedrock.configs.SBConfig;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;

public class SBWorldGeneration
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        Block defaultBlock;
        if (!SBConfig.isActive || world.field_73011_w.field_76577_b == WorldType.field_77138_c) {
            return;
        }
        if (world.field_73011_w.field_76574_g > 0 || world.field_73011_w.field_76574_g < -1) {
            return;
        }
        boolean isNether = world.field_73011_w.field_76574_g == -1;
        Block replaceBlock = defaultBlock = isNether ? Blocks.field_150424_aL : Blocks.field_150348_b;
        boolean useCustomSpawn = defaultBlock.equals(Blocks.field_150348_b) && (SBConfig.spawnDiamonds || SBConfig.spawnRedstone || SBConfig.spawnLapis);
        int posX = 0;
        int posZ = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int posY;
                posX = chunkX * 16 + x;
                posZ = chunkZ * 16 + z;
                if (isNether) {
                    for (posY = 127; posY > 121; --posY) {
                        if (!this.isBedrock(world, posX, posY, posZ)) continue;
                        world.func_147465_d(posX, posY, posZ, replaceBlock, 0, 0);
                    }
                }
                for (posY = 5; posY > 0; --posY) {
                    if (!this.isBedrock(world, posX, posY, posZ)) continue;
                    if (useCustomSpawn) {
                        double rand = random.nextDouble();
                        replaceBlock = SBConfig.spawnDiamonds && rand < 1.0E-5 ? Blocks.field_150482_ag : (SBConfig.spawnRedstone && rand < 2.0E-4 ? Blocks.field_150450_ax : (SBConfig.spawnLapis && rand < 5.0E-4 ? Blocks.field_150369_x : defaultBlock));
                    }
                    world.func_147465_d(posX, posY, posZ, replaceBlock, 0, 0);
                }
            }
        }
    }

    private boolean isBedrock(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == Blocks.field_150357_h;
    }
}

