/*
 * Decompiled with CFR 0.152.
 */
package cofh.block;

import cofh.api.tileentity.ISecureTile;
import cofh.core.CoFHProps;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.social.RegistryFriends;
import cofh.util.CoreUtils;
import cofh.util.ServerHelper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;

public abstract class TileCoFHBase
extends TileEntity {
    public void blockBroken() {
    }

    public void blockDismantled() {
        this.blockBroken();
    }

    public boolean canPlayerAccess(String name) {
        if (!(this instanceof ISecureTile)) {
            return false;
        }
        ISecureTile.AccessMode access = ((ISecureTile)((Object)this)).getAccess();
        String owner = ((ISecureTile)((Object)this)).getOwnerName();
        return access.isPublic() || CoFHProps.enableOpSecureAccess && CoreUtils.isOp(name) || owner.equals("[None]") || owner.equals(name) || access.isRestricted() && RegistryFriends.playerHasAccess(name, owner);
    }

    public boolean canPlayerDismantle(EntityPlayer player) {
        return true;
    }

    public int getBlockID() {
        return this.func_70311_o().field_71990_ca;
    }

    public int getLightValue() {
        return 0;
    }

    public abstract String getName();

    public abstract int getType();

    public boolean isUseable(EntityPlayer player) {
        return this.field_70331_k == null ? true : this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this && player.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 96.0;
    }

    public void onNeighborBlockChange() {
    }

    public void onNeighborTileChange(int tileX, int tileY, int tileZ) {
    }

    public boolean onWrench(EntityPlayer player, int hitSide) {
        return false;
    }

    public boolean openGui(EntityPlayer player) {
        return false;
    }

    public void onTileChanged() {
        if (this.field_70331_k != null) {
            this.field_70331_k.func_96440_m(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0);
        }
    }

    protected boolean timeCheck() {
        return this.field_70331_k.func_82737_E() % 32L == 0L;
    }

    protected boolean timeCheckEighth() {
        return this.field_70331_k.func_82737_E() % 4L == 0L;
    }

    public Packet func_70319_e() {
        return this.getDescriptionPayload().getPacket();
    }

    public Payload getDescriptionPayload() {
        return Payload.getDescriptionPayload(this);
    }

    public void sendDescPacket() {
        PacketUtils.sendToPlayers(this.func_70319_e(), this);
    }

    public void sendUpdatePacket(Side side) {
        if (this.field_70331_k == null) {
            return;
        }
        if (side == Side.CLIENT && ServerHelper.isServerWorld(this.field_70331_k)) {
            PacketUtils.sendToPlayers(this.func_70319_e(), this);
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        } else if (side == Side.SERVER && ServerHelper.isClientWorld(this.field_70331_k)) {
            PacketUtils.sendToServer(this.func_70319_e());
        }
    }

    public int getInvSlotCount() {
        return 0;
    }

    public void receiveGuiNetworkData(int i, int j) {
    }

    public void sendGuiNetworkData(Container container, ICrafting player) {
    }

    public void callNeighborTileChange() {
        if (this.func_70311_o() != null) {
            this.field_70331_k.func_96440_m(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
        }
    }

    public int getComparatorInput() {
        return 0;
    }
}

