/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm;

import codechicken.core.launch.DepLoader;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.awt.Desktop;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

@IFMLLoadingPlugin.TransformerExclusions(value={"cofh.asm"})
public class LoadingPlugin
implements IFMLLoadingPlugin {
    public static final String MC_VERSION = "[1.6.4]";
    public static ArrayList<String> transformersList = new ArrayList();
    public File myLocation;

    public LoadingPlugin() {
        DepLoader.load();
    }

    public static void attemptClassLoad(String className, String failMessage) {
        try {
            Class.forName(className);
            transformersList.add(className);
        }
        catch (ClassNotFoundException e) {
            FMLLog.warning((String)failMessage, (Object[])new Object[0]);
        }
    }

    public String[] getLibraryRequestClass() {
        return null;
    }

    public static void versionCheck(String reqVersion, String mod) {
        String mcVersion = (String)FMLInjectionData.data()[4];
        if (!VersionParser.parseRange((String)reqVersion).containsVersion((ArtifactVersion)new DefaultArtifactVersion(mcVersion))) {
            String err = "This version of " + mod + " does not support Minecraft version " + mcVersion;
            System.err.println(err);
            JEditorPane ep = new JEditorPane("text/html", "<html>" + err + "<br>Remove it from your coremods folder and check <a href=\"http://thermalexpansion.wikispaces.com/\">here</a> for updates" + "</html>");
            ep.setEditable(false);
            ep.setOpaque(false);
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    try {
                        if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            Desktop.getDesktop().browse(event.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            JOptionPane.showMessageDialog(null, ep, "Fatal error", 0);
            System.exit(1);
        }
    }

    public String[] getASMTransformerClass() {
        return transformersList.toArray(new String[]{""});
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        if (data.containsKey("coremodLocation")) {
            this.myLocation = (File)data.get("coremodLocation");
        }
    }

    static {
        LoadingPlugin.attemptClassLoad("cofh.asm.TransformerCore", "Failed to find Main Transformer! Critical Issue!");
        LoadingPlugin.attemptClassLoad("cofh.asm.TransformerMasquerade", "Failed to find SubCoreMod Masquerade!");
    }
}

