/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm;

import codechicken.core.asm.MCPDeobfuscationTransformer;
import codechicken.lib.asm.ObfMapping;
import cofh.CoFHCore;
import java.io.DataInputStream;
import java.io.File;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassOverride {
    public static byte[] overrideBytes(String name, byte[] bytes, String className, File location) {
        if (!className.equals(name.replace(".", "/"))) {
            return bytes;
        }
        try {
            ZipFile zip = new ZipFile(location);
            ZipEntry entry = zip.getEntry(className + ".class");
            if (entry == null) {
                zip.close();
                if (ObfMapping.obfuscated) {
                    CoFHCore.log.severe(name + " not found in " + location.getName());
                } else {
                    String rev = MCPDeobfuscationTransformer.unmap((String)className);
                    if (rev != null && !rev.equals(className)) {
                        byte[] nbytes = ClassOverride.overrideBytes(rev.replace('/', '.'), bytes, rev, location);
                        return MCPDeobfuscationTransformer.instance().transform(rev, null, nbytes);
                    }
                }
            } else {
                DataInputStream zin = new DataInputStream(zip.getInputStream(entry));
                bytes = new byte[(int)entry.getSize()];
                zin.readFully(bytes);
                zip.close();
                CoFHCore.log.info(name + " was overriden from " + location.getName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error overriding " + name + " from " + location.getName(), e);
        }
        return bytes;
    }
}

