/*
 * Decompiled with CFR 0.152.
 */
package cofh;

import cofh.command.CommandHandler;
import cofh.core.CoFHProps;
import cofh.core.Proxy;
import cofh.entity.CoFHPlayerTracker;
import cofh.gui.GuiHandler;
import cofh.hud.CoFHServerKeyHandler;
import cofh.network.PacketHandler;
import cofh.util.ConfigHandler;
import cofh.util.RegistryEnderAttuned;
import cofh.util.StringHelper;
import cofh.util.fluid.BucketHandler;
import cofh.util.version.VersionHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="CoFHCore", name="CoFH Core", version="2.0.0.2")
@NetworkMod(clientSideRequired=true, serverSideRequired=false, tinyPacketHandler=PacketHandler.class)
public class CoFHCore {
    @Mod.Instance(value="CoFHCore")
    public static CoFHCore instance;
    @SidedProxy(clientSide="cofh.core.ProxyClient", serverSide="cofh.core.Proxy")
    public static Proxy proxy;
    public static MinecraftServer server;
    public static final Logger log;
    public static final GuiHandler guiHandler;
    public static final ConfigHandler config;
    public static final VersionHandler version;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        version.checkForNewVersion();
        CoFHProps.configDir = event.getModConfigurationDirectory();
        config.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/CoFHCore.cfg")));
        String category = "general";
        String comment = "Enable this to be informed of non-critical updates. You will still receive critical update notifications.";
        CoFHProps.enableUpdateNotice = config.get(category, "EnableUpdateNotifications", true, comment);
        category = "gui";
        CoFHProps.enableInformationTabs = config.get(category, "EnableInformationTabs", true);
        CoFHProps.enableTutorialTabs = config.get(category, "EnableTutorialTabs", true);
        category = "gui.hud";
        CoFHProps.enableItemPickupModule = config.get(category, "EnableItemPickupModule", true, "Enable messages that notify you of item pickups. Note: You cannot disable this if your Minecraft username is \"Jadedcat\"");
        category = "gui.tooltips";
        comment = "This adds a tooltip prompting you to press Shift for more details on various items.";
        StringHelper.displayShiftForDetail = config.get(category, "DisplayHoldShiftForDetail", true, comment);
        comment = "This option determines if items contained in other items are displayed as a single quantity or a stack count.";
        StringHelper.displayStackCount = config.get(category, "DisplayStackCountInInventory", false, comment);
        category = "security";
        comment = "Enable this to allow for Server Ops to access 'secure' blocks. Your players will be warned upon server connection. (Default: false)";
        CoFHProps.enableOpSecureAccess = config.get(category, "OpsCanAccessSecureBlocks", false, comment);
        comment = "Enable this to be warned about Ops having access to 'secure' blocks when connecting to a server. (Default: true)";
        CoFHProps.enableOpSecureAccessWarning = config.get(category, "OpsCanAccessSecureBlocksWarning", true, comment);
        config.save();
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        CoFHPlayerTracker.initialize();
        BucketHandler.initialize();
        CoFHServerKeyHandler.initialize();
        this.registerOreDictionaryEntries();
        this.fixOreDerptionary();
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent event) {
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.registerRenderInformation();
        proxy.registerTickHandlers();
        proxy.registerPacketInformation();
        config.cleanUp(false, true);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        RegistryEnderAttuned.linkConf = new Configuration(new File(DimensionManager.getCurrentSaveRootDirectory(), "/cofh/EnderFrequencies.cfg"));
        RegistryEnderAttuned.linkConf.load();
        CommandHandler.initCommands(event);
        server = event.getServer();
    }

    public void registerOreDictionaryEntries() {
        this.registerOreDictionaryEntry("sandstone", new ItemStack(Block.field_71957_Q, 1, Short.MAX_VALUE));
        this.registerOreDictionaryEntry("glass", Block.field_71946_M);
        this.registerOreDictionaryEntry("oreCoal", Block.field_71950_I);
        this.registerOreDictionaryEntry("cloth", new ItemStack(Block.field_72101_ab, 1, Short.MAX_VALUE));
        this.registerOreDictionaryEntry("blockGold", Block.field_72105_ah);
        this.registerOreDictionaryEntry("blockIron", Block.field_72083_ai);
        this.registerOreDictionaryEntry("blockDiamond", Block.field_72071_ax);
        this.registerOreDictionaryEntry("blockGlowstone", Block.field_72014_bd);
        this.registerOreDictionaryEntry("blockEmerald", Block.field_72076_bV);
        this.registerOreDictionaryEntry("blockRedstone", Block.field_94341_cq);
        this.registerOreDictionaryEntry("coal", new ItemStack(Item.field_77705_m, 1, 0));
        this.registerOreDictionaryEntry("charcoal", new ItemStack(Item.field_77705_m, 1, 1));
        this.registerOreDictionaryEntry("ingotIron", Item.field_77703_o);
        this.registerOreDictionaryEntry("ingotGold", Item.field_77717_p);
        this.registerOreDictionaryEntry("dustRedstone", Item.field_77767_aC);
        this.registerOreDictionaryEntry("slimeball", Item.field_77761_aM);
        this.registerOreDictionaryEntry("dustGlowstone", Item.field_77751_aT);
        this.registerOreDictionaryEntry("nuggetGold", Item.field_77733_bq);
    }

    public void fixOreDerptionary() {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        ArrayList<ShapedOreRecipe> recipesToRemove = new ArrayList<ShapedOreRecipe>();
        ArrayList<ShapedOreRecipe> recipesToAdd = new ArrayList<ShapedOreRecipe>();
        ItemStack[] stairs = new ItemStack[]{new ItemStack(Block.field_72063_at), new ItemStack(Block.field_72074_bW), new ItemStack(Block.field_72072_bX), new ItemStack(Block.field_72070_bY)};
        for (Object obj : recipes) {
            int i;
            ItemStack output;
            ShapedOreRecipe recipe;
            if (obj instanceof ShapedOreRecipe) {
                recipe = (ShapedOreRecipe)obj;
                output = recipe.func_77571_b();
                for (i = 0; i < 4; ++i) {
                    if (output.field_77993_c != stairs[i].field_77993_c) continue;
                    recipesToRemove.add(recipe);
                }
                continue;
            }
            if (!(obj instanceof ShapedRecipes)) continue;
            recipe = (ShapedRecipes)obj;
            output = recipe.func_77571_b();
            for (i = 0; i < 4; ++i) {
                if (output.field_77993_c != stairs[i].field_77993_c) continue;
                recipesToRemove.add(recipe);
            }
        }
        recipesToAdd.add(new ShapedOreRecipe(new ItemStack(Block.field_72063_at, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new ItemStack(Block.field_71988_x, 1, 0)}));
        recipesToAdd.add(new ShapedOreRecipe(new ItemStack(Block.field_72074_bW, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new ItemStack(Block.field_71988_x, 1, 1)}));
        recipesToAdd.add(new ShapedOreRecipe(new ItemStack(Block.field_72072_bX, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new ItemStack(Block.field_71988_x, 1, 2)}));
        recipesToAdd.add(new ShapedOreRecipe(new ItemStack(Block.field_72070_bY, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new ItemStack(Block.field_71988_x, 1, 3)}));
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
    }

    private boolean registerOreDictionaryEntry(String oreName, Block ore) {
        return this.registerOreDictionaryEntry(oreName, new ItemStack(ore));
    }

    private boolean registerOreDictionaryEntry(String oreName, Item ore) {
        return this.registerOreDictionaryEntry(oreName, new ItemStack(ore));
    }

    private boolean registerOreDictionaryEntry(String oreName, ItemStack ore) {
        if (OreDictionary.getOres((String)oreName).isEmpty()) {
            OreDictionary.registerOre((String)oreName, (ItemStack)ore);
            return true;
        }
        return false;
    }

    static {
        log = Logger.getLogger("CoFHCore");
        guiHandler = new GuiHandler();
        config = new ConfigHandler("2.0.0.2");
        version = new VersionHandler("CoFH Core", "2.0.0.2", "http://teamcofh.com/cofhcore/version/version.txt");
        log.setParent(FMLLog.getLogger());
    }
}

