/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import tonius.simplyjetpacks.KeyboardTracker;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.item.ItemSJArmorEnergy;
import tonius.simplyjetpacks.util.SJTranslator;

public class ItemSJJetpack
extends ItemSJArmorEnergy {
    protected int tickEnergy;
    protected int tickEnergyHover;
    protected double maxSpeed;
    protected double acceleration;
    protected double forwardThrust;
    protected double hoverModeIdleSpeed;
    protected double hoverModeActiveSpeed;

    public ItemSJJetpack(int id, EnumArmorMaterial material, String name, int maxEnergy, int maxInput, int tickEnergy, double maxSpeed, double acceleration, double forwardThrust, double hoverModeIdleSpeed, double hoverModeActiveSpeed) {
        super(id, material, 2, 1, name, maxEnergy, maxInput, 0);
        this.tickEnergy = tickEnergy;
        this.tickEnergyHover = (int)((double)tickEnergy / 1.5);
        this.maxSpeed = maxSpeed;
        this.acceleration = acceleration;
        this.forwardThrust = forwardThrust;
        this.hoverModeIdleSpeed = hoverModeIdleSpeed;
        this.hoverModeActiveSpeed = hoverModeActiveSpeed;
    }

    public void func_77633_a(int id, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(id, 1, 31));
        ItemStack fullJetpack = new ItemStack(id, 1, 1);
        fullJetpack.field_77990_d = new NBTTagCompound();
        fullJetpack.field_77990_d.func_74768_a("Energy", this.getMaxEnergyStored(fullJetpack));
        list.add(fullJetpack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.GOLD + SJTranslator.translate("jetpack.tooltip.charge") + ": " + EnumChatFormatting.GRAY + this.getEnergyStored(itemStack) + "/" + this.getMaxEnergyStored(itemStack) + " RF");
        String onOrOff = this.isOn(itemStack) ? EnumChatFormatting.GREEN + SJTranslator.translate("jetpack.tooltip.state.on") : EnumChatFormatting.RED + SJTranslator.translate("jetpack.tooltip.state.off");
        list.add(EnumChatFormatting.GOLD + SJTranslator.translate("jetpack.tooltip.state") + ": " + onOrOff);
        String enabledOrDisabled = this.isHoverModeActive(itemStack) ? EnumChatFormatting.GREEN + SJTranslator.translate("jetpack.tooltip.hoverMode.enabled") : EnumChatFormatting.RED + SJTranslator.translate("jetpack.tooltip.hoverMode.disabled");
        list.add(EnumChatFormatting.GOLD + SJTranslator.translate("jetpack.tooltip.hoverMode") + ": " + enabledOrDisabled);
        int currentTickEnergy = this.isHoverModeActive(itemStack) ? this.tickEnergyHover : this.tickEnergy;
        list.add(EnumChatFormatting.BLUE + SJTranslator.translate("jetpack.tooltip.energyUsage") + ": " + EnumChatFormatting.GRAY + currentTickEnergy + " RF/t");
        list.add(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + SJTranslator.translate("jetpack.tooltip.description.1"));
        list.add(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + SJTranslator.translate("jetpack.tooltip.description.2"));
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77628_j(ItemStack itemStack) {
        if (itemStack.func_77973_b() == SimplyJetpacks.jetpackTier3) {
            return EnumChatFormatting.YELLOW + super.func_77628_j(itemStack);
        }
        if (itemStack.func_77973_b() == SimplyJetpacks.jetpackTier4) {
            return EnumChatFormatting.AQUA + super.func_77628_j(itemStack);
        }
        return super.func_77628_j(itemStack);
    }

    @Override
    public String getActivateMsg() {
        return SJTranslator.translate("jetpack.chat.engine") + " " + EnumChatFormatting.GREEN + SJTranslator.translate("jetpack.chat.enabled");
    }

    @Override
    public String getDeactivateMsg() {
        return SJTranslator.translate("jetpack.chat.engine") + " " + EnumChatFormatting.RED + SJTranslator.translate("jetpack.chat.disabled");
    }

    public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack) {
        if (this.isOn(itemStack)) {
            double hoverSpeed;
            double d = hoverSpeed = player.func_70093_af() ? this.hoverModeActiveSpeed : this.hoverModeIdleSpeed;
            if (KeyboardTracker.isJumpKeyDown(player)) {
                this.useJetpack((EntityLivingBase)player, itemStack);
            } else if (this.isHoverModeActive(itemStack) && !player.field_70122_E && player.field_70181_x < -hoverSpeed) {
                this.subtractEnergy(itemStack, this.tickEnergyHover, false);
                if (this.getEnergyStored(itemStack) > 0) {
                    player.field_70181_x = -hoverSpeed;
                    if (KeyboardTracker.isForwardKeyDown(player)) {
                        player.func_70060_a(0.0f, (float)this.forwardThrust, (float)this.forwardThrust);
                    }
                    player.field_70143_R = 0.0f;
                    if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).field_71135_a.field_72572_g = 0;
                    }
                    this.updateEnergyDisplay(itemStack);
                    this.sendJetpackPacket((EntityLivingBase)player, true);
                }
            }
        }
    }

    public void useJetpack(EntityLivingBase user, ItemStack itemStack) {
        boolean flown = false;
        if (!this.isHoverModeActive(itemStack)) {
            this.subtractEnergy(itemStack, this.tickEnergy, false);
            if (this.getEnergyStored(itemStack) > 0) {
                user.field_70181_x = Math.min(user.field_70181_x + this.acceleration, this.maxSpeed);
                flown = true;
            }
        } else {
            this.subtractEnergy(itemStack, this.tickEnergyHover, false);
            if (this.getEnergyStored(itemStack) > 0) {
                user.field_70181_x = Math.min(user.field_70181_x + this.acceleration, this.hoverModeActiveSpeed);
                flown = true;
            }
        }
        if (flown) {
            if (!(user instanceof EntityPlayer)) {
                user.func_70060_a(0.0f, (float)this.forwardThrust, (float)this.forwardThrust);
            } else if (KeyboardTracker.isForwardKeyDown((EntityPlayer)user)) {
                user.func_70060_a(0.0f, (float)this.forwardThrust, (float)this.forwardThrust);
            }
            user.field_70143_R = 0.0f;
            if (user instanceof EntityPlayerMP) {
                ((EntityPlayerMP)user).field_71135_a.field_72572_g = 0;
            }
            this.sendJetpackPacket(user, this.isHoverModeActive(itemStack));
        }
        this.updateEnergyDisplay(itemStack);
    }

    public void sendJetpackPacket(EntityLivingBase user, boolean hoverMode) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(0);
            data.writeInt(user.field_70157_k);
            data.writeBoolean(hoverMode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "SmpJet";
        packet.field_73629_c = bytes.toByteArray();
        packet.field_73628_b = bytes.size();
        PacketDispatcher.sendPacketToAllAround((double)user.field_70165_t, (double)user.field_70163_u, (double)user.field_70161_v, (double)128.0, (int)user.field_70170_p.field_73011_w.field_76574_g, (Packet)packet);
    }

    public void toggleHoverMode(ItemStack itemStack, EntityPlayer player) {
        if (this.isHoverModeActive(itemStack)) {
            player.func_71035_c(SJTranslator.translate("jetpack.chat.hoverMode") + " " + EnumChatFormatting.RED + SJTranslator.translate("jetpack.chat.disabled"));
            itemStack.field_77990_d.func_74757_a("HoverModeActive", false);
        } else {
            player.func_71035_c(SJTranslator.translate("jetpack.chat.hoverMode") + " " + EnumChatFormatting.GREEN + SJTranslator.translate("jetpack.chat.enabled"));
            itemStack.field_77990_d.func_74757_a("HoverModeActive", true);
        }
    }

    public boolean isHoverModeActive(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        return itemStack.field_77990_d.func_74767_n("HoverModeActive");
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }
}

