/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item;

import cofh.api.energy.IEnergyContainerItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import tonius.simplyjetpacks.item.ItemSJArmor;

public class ItemSJArmorEnergy
extends ItemSJArmor
implements ISpecialArmor,
IEnergyContainerItem {
    protected int maxEnergy;
    protected int maxInput;
    protected int maxOutput;
    protected ISpecialArmor.ArmorProperties properties = new ISpecialArmor.ArmorProperties(0, 1.0, 0);

    public ItemSJArmorEnergy(int id, EnumArmorMaterial material, int renderIndex, int armorType, String name, int maxEnergy, int maxInput, int maxOutput) {
        super(id, material, renderIndex, armorType, name, name);
        this.func_77656_e(30);
        this.setNoRepair();
        this.maxEnergy = maxEnergy;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
    }

    public void toggle(ItemStack itemStack, EntityPlayer player) {
        if (this.isOn(itemStack)) {
            player.func_71035_c(this.getDeactivateMsg());
            itemStack.field_77990_d.func_74757_a("On", false);
        } else {
            player.func_71035_c(this.getActivateMsg());
            itemStack.field_77990_d.func_74757_a("On", true);
        }
    }

    public String getActivateMsg() {
        return "Enabled";
    }

    public String getDeactivateMsg() {
        return "Disabled";
    }

    public boolean isOn(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        return itemStack.field_77990_d.func_74767_n("On");
    }

    public void updateEnergyDisplay(ItemStack itemStack) {
        double displayedDamage = 31.0 - (double)this.getEnergyStored(itemStack) / (double)this.getMaxEnergyStored(itemStack) * 30.0;
        itemStack.func_77964_b((int)Math.floor(displayedDamage));
    }

    public int addEnergy(ItemStack container, int energyToAdd, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energyCurrent = container.field_77990_d.func_74762_e("Energy");
        int energyAdded = Math.min(this.getMaxEnergyStored(container) - energyCurrent, energyToAdd);
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energyCurrent += energyAdded);
            this.updateEnergyDisplay(container);
        }
        return energyAdded;
    }

    public int subtractEnergy(ItemStack container, int energyToSubtract, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energyCurrent = container.field_77990_d.func_74762_e("Energy");
        int energySubtracted = Math.min(energyCurrent, energyToSubtract);
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energyCurrent -= energySubtracted);
            this.updateEnergyDisplay(container);
        }
        return energySubtracted;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return this.properties;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = this.getEnergyStored(container);
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energy, Math.min(maxReceive, this.maxInput));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        this.updateEnergyDisplay(container);
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = this.getEnergyStored(container);
        int energyExtracted = Math.min(energy, Math.min(maxExtract, this.maxOutput));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        this.updateEnergyDisplay(container);
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.maxEnergy;
    }
}

