/*
 * Decompiled with CFR 0.152.
 */
package cofh.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;

@SideOnly(value=Side.CLIENT)
public class GuiTextList
extends Gui {
    public static final int X_OFFSET = 4;
    public static final int Y_OFFSET = 2;
    private final FontRenderer fRend;
    public int xPos = 0;
    public int yPos = 0;
    public int width = 12;
    public int height = 12;
    public boolean drawBackground = true;
    public boolean drawBorder = true;
    public boolean isEnabled = true;
    public boolean isFocused = false;
    public int borderColor = -6250336;
    public int backgroundColor = -16777216;
    public int selectedLineColor = -16777216;
    public int textColor = 0xE0E0E0;
    public int selectedTextColor = 0xE0E0E0;
    public int displayLines = 0;
    public int lineHeight = 10;
    public List<String> textLines = new LinkedList<String>();
    public int startLine = 0;
    public int selectedLine = -1;
    public boolean highlightSelectedLine = false;

    public GuiTextList(FontRenderer fontRenderer, int x, int y, int w, int lines) {
        this.fRend = fontRenderer;
        this.xPos = x;
        this.yPos = y;
        this.displayLines = lines;
        this.lineHeight = fontRenderer.field_78288_b + 1;
        this.width = w;
        this.height = this.displayLines * this.lineHeight + 2;
    }

    public void drawBackground() {
        if (this.drawBorder) {
            GuiTextList.func_73734_a((int)(this.xPos - 1), (int)(this.yPos - 1), (int)(this.xPos + this.width + 1), (int)(this.yPos + this.height + 1), (int)this.borderColor);
        }
        if (this.drawBackground) {
            GuiTextList.func_73734_a((int)this.xPos, (int)this.yPos, (int)(this.xPos + this.width), (int)(this.yPos + this.height), (int)this.backgroundColor);
        }
    }

    public void drawText() {
        for (int i = this.startLine; i < this.startLine + this.displayLines; ++i) {
            if (this.textLines.size() <= i) continue;
            String lineToDraw = this.fRend.func_78269_a(this.textLines.get(i), this.width);
            if (this.selectedLine == i && this.highlightSelectedLine) {
                GuiTextList.func_73734_a((int)this.xPos, (int)(this.yPos + 1 + this.lineHeight * (i - this.startLine)), (int)(this.xPos + this.width), (int)(this.yPos + this.lineHeight * (1 + i - this.startLine)), (int)this.selectedLineColor);
                this.fRend.func_78261_a(lineToDraw, this.xPos + 4, this.yPos + 2 + this.lineHeight * (i - this.startLine), this.selectedTextColor);
                continue;
            }
            this.fRend.func_78261_a(lineToDraw, this.xPos + 4, this.yPos + 2 + this.lineHeight * (i - this.startLine), this.textColor);
        }
    }

    public int getSelectedLineYPos() {
        if (this.selectedLine < this.startLine || this.selectedLine > this.startLine + this.displayLines - 1) {
            return -1;
        }
        return this.yPos + 1 + this.lineHeight * (this.selectedLine - this.startLine);
    }

    public String mouseClicked(int mouseX, int mouseY, int mouseButton, int offsetY) {
        int theLine = (mouseY - offsetY) / this.lineHeight;
        if (this.textLines.size() > theLine + this.startLine) {
            return this.textLines.get(theLine + this.startLine);
        }
        return "";
    }

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    public void setFocused(boolean focus) {
        this.isFocused = focus;
    }

    public void addLine(String theLine) {
        this.textLines.add(theLine);
    }

    public void selectLine(int i) {
        this.selectedLine = i;
    }

    public void scrollUp() {
        ++this.startLine;
        if (this.startLine > this.textLines.size() - this.displayLines) {
            this.startLine = this.textLines.size() - this.displayLines;
        }
        if (this.startLine < 0) {
            this.startLine = 0;
        }
    }

    public void scrollDown() {
        --this.startLine;
        if (this.startLine < 0) {
            this.startLine = 0;
        }
    }
}

