/*
 * Decompiled with CFR 0.152.
 */
package cofh.social;

import cofh.CoFHCore;
import cofh.core.CoFHProps;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.social.SocialPacketHandler;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.Configuration;

public class RegistryFriends {
    public static int guiId;
    public static Configuration friendConf;
    public static List<String> clientPlayerFriends;

    public static void initialize() {
        friendConf = new Configuration(new File(CoFHProps.configDir, "/cofh/CoFHSocial-Friends.cfg"));
        friendConf.load();
        guiId = CoFHCore.proxy.registerGui("FriendsList", false);
    }

    public static boolean addFriend(String ownerName, String friendName) {
        if (ownerName == null || friendName == null) {
            return false;
        }
        friendConf.get(ownerName.toLowerCase(), friendName.toLowerCase(), 1);
        friendConf.save();
        return true;
    }

    public static boolean removeFriend(String ownerName, String friendName) {
        if (ownerName == null || friendName == null) {
            return false;
        }
        ownerName = ownerName.toLowerCase();
        friendName = friendName.toLowerCase();
        if (friendConf.hasCategory(ownerName) && friendConf.getCategory(ownerName).containsKey(friendName)) {
            friendConf.getCategory(ownerName).remove((Object)friendName);
            friendConf.save();
            return true;
        }
        return false;
    }

    public static boolean playerHasAccess(String playerName, String ownerName) {
        return playerName != null && ownerName != null && (playerName.toLowerCase().matches(ownerName.toLowerCase()) || friendConf.hasCategory(ownerName.toLowerCase())) && friendConf.getCategory(ownerName.toLowerCase()).containsKey(playerName.toLowerCase());
    }

    public static void sendFriendsToPlayer(EntityPlayerMP thePlayer) {
        Payload thePayload = Payload.getPayload(SocialPacketHandler.packetID);
        thePayload.addByte(SocialPacketHandler.Type.FRIEND_LIST.ordinal());
        thePayload.addInt(friendConf.getCategory(thePlayer.field_71092_bJ.toLowerCase()).keySet().size());
        for (String theName : friendConf.getCategory(thePlayer.field_71092_bJ.toLowerCase()).keySet()) {
            thePayload.addString(theName);
        }
        PacketUtils.sendToPlayer(thePayload.getPacket(), (EntityPlayer)thePlayer);
    }

    static {
        clientPlayerFriends = new LinkedList<String>();
    }
}

