/*
 * Decompiled with CFR 0.152.
 */
package alexndr.SimpleOres.plugins.fusion;

import alexndr.SimpleOres.api.helpers.LogHelper;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class Settings {
    public static Configuration settings;
    public static int thyriumBowDamageModifier;
    public static int thyriumBowZoomModifier;
    public static int sinisiteBowDamageModifier;
    public static int sinisiteBowKnockbackModifier;
    public static boolean enableToolStatModification;
    public static boolean enableArmorStatModification;
    public static boolean enableBlockStatModification;
    public static boolean enableCustomFusionRecipes;
    public static boolean enableExtraChunkRecipes;
    public static int bronzeMiningLevel;
    public static int thyriumMiningLevel;
    public static int sinisiteMiningLevel;
    public static int bronzeUsesNum;
    public static int thyriumUsesNum;
    public static int sinisiteUsesNum;
    public static float bronzeMiningSpeed;
    public static float thyriumMiningSpeed;
    public static float sinisiteMiningSpeed;
    public static int bronzeDamageVsEntity;
    public static int thyriumDamageVsEntity;
    public static int sinisiteDamageVsEntity;
    public static int bronzeEnchantability;
    public static int thyriumEnchantability;
    public static int sinisiteEnchantability;
    public static int bronzeArmorDurability;
    public static int thyriumArmorDurability;
    public static int sinisiteArmorDurability;
    public static int[] bronzeArmorDamageReduction;
    public static int[] thyriumArmorDamageReduction;
    public static int[] sinisiteArmorDamageReduction;
    public static int bronzeArmorEnchantability;
    public static int thyriumArmorEnchantability;
    public static int sinisiteArmorEnchantability;
    public static float bronzeBlockHardness;
    public static float thyriumBlockHardness;
    public static float sinisiteBlockHardness;
    public static float bronzeBlockResistance;
    public static float thyriumBlockResistance;
    public static float sinisiteBlockResistance;
    public static float fusionFurnaceHardness;
    public static float fusionFurnaceResistance;
    public static float fusionFurnaceLightValue;
    public static int recipeNum;
    public static String exampleRecipe;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSettings(FMLPreInitializationEvent event) {
        File installDir = event.getModConfigurationDirectory();
        File configDir = new File(installDir, "SimpleOres/Plugins");
        File settingsFile = new File(configDir, "Fusion Settings.cfg");
        settings = new Configuration(settingsFile);
        LogHelper.verboseInfo("Fusion Plugin: Loading settings file at: '" + settingsFile.getAbsolutePath() + "'...");
        try {
            settings.load();
            enableToolStatModification = settings.get("Toggles", "Enable Tool Stat Modification? (Advanced)", false).getBoolean(enableToolStatModification);
            enableArmorStatModification = settings.get("Toggles", "Enable Armor Stat Modification? (Advanced)", false).getBoolean(enableArmorStatModification);
            enableBlockStatModification = settings.get("Toggles", "Enable Block Stat Modification? (Advanced)", false).getBoolean(enableBlockStatModification);
            enableCustomFusionRecipes = settings.get("Toggles", "Enable Custom Fusion Furnace Recipes? (Advanced)", false).getBoolean(enableCustomFusionRecipes);
            enableExtraChunkRecipes = settings.get("Toggles", "Enable Extra Chunk Recipes?", false).getBoolean(enableExtraChunkRecipes);
            thyriumBowDamageModifier = settings.get("Bow Modifiers", "Thyrium Bow Damage Modifier", 5).getInt();
            thyriumBowZoomModifier = settings.get("Bow Modifiers", "Thyrium Bow Zoom Modifier", 35).getInt();
            sinisiteBowDamageModifier = settings.get("Bow Modifiers", "Sinisite Bow Damage Modifier", 6).getInt();
            sinisiteBowKnockbackModifier = settings.get("Bow Modifiers", "Sinisite Bow Knockback Modifier", 2).getInt();
            if (enableToolStatModification) {
                bronzeMiningLevel = settings.get("Tool Stats", "Bronze Mining Level", 2).getInt();
                bronzeUsesNum = settings.get("Tool Stats", "Bronze Uses Number", 600).getInt();
                bronzeMiningSpeed = (float)settings.get("Tool Stats", "Bronze Mining Speed", 9.0).getDouble((double)bronzeMiningSpeed);
                bronzeDamageVsEntity = settings.get("Tool Stats", "Bronze Damage Vs Entity", 2).getInt();
                bronzeEnchantability = settings.get("Tool Stats", "Bronze Enchantability", 7).getInt();
                thyriumMiningLevel = settings.get("Tool Stats", "Thyrium Mining Level", 3).getInt();
                thyriumUsesNum = settings.get("Tool Stats", "Thyrium Uses Number", 2000).getInt();
                thyriumMiningSpeed = (float)settings.get("Tool Stats", "Thyrium Mining Speed", 22.0).getDouble((double)thyriumMiningSpeed);
                thyriumDamageVsEntity = settings.get("Tool Stats", "Thyrium Damage Vs Entity", 6).getInt();
                thyriumEnchantability = settings.get("Tool Stats", "Thyrium Enchantability", 28).getInt();
                sinisiteMiningLevel = settings.get("Tool Stats", "Sinisite Mining Level", 5).getInt();
                sinisiteUsesNum = settings.get("Tool Stats", "Sinisite Uses Number", 4100).getInt();
                sinisiteMiningSpeed = (float)settings.get("Tool Stats", "Sinisite Mining Speed", 18.0).getDouble((double)sinisiteMiningSpeed);
                sinisiteDamageVsEntity = settings.get("Tool Stats", "Sinisite Damage Vs Entity", 8).getInt();
                sinisiteEnchantability = settings.get("Tool Stats", "Sinisite Enchantability", 11).getInt();
            } else {
                Settings.defaultToolStats();
            }
            if (enableArmorStatModification) {
                bronzeArmorDurability = settings.get("Armor Stats", "Bronze Armor Durability", 16).getInt();
                bronzeArmorDamageReduction = settings.get("Armor Stats", "Bronze Armor Damage Reduction Array", new int[]{3, 5, 3, 1}).getIntList();
                bronzeArmorEnchantability = settings.get("Armor Stats", "Bronze Armor Enchantability", 7).getInt();
                thyriumArmorDurability = settings.get("Armor Stats", "Thyrium Armor Durability", 39).getInt();
                thyriumArmorDamageReduction = settings.get("Armor Stats", "Thyrium Armor Damage Reduction Array", new int[]{4, 7, 6, 3}).getIntList();
                thyriumArmorEnchantability = settings.get("Armor Stats", "Thyrium Armor Enchantability", 28).getInt();
                sinisiteArmorDurability = settings.get("Armor Stats", "Sinisite Armor Durability", 56).getInt();
                sinisiteArmorDamageReduction = settings.get("Armor Stats", "Sinisite Armor Damage Reduction Array", new int[]{5, 8, 6, 5}).getIntList();
                sinisiteArmorEnchantability = settings.get("Armor Stats", "Sinisite Armor Enchantability", 11).getInt();
            } else {
                Settings.defaultArmorStats();
            }
            if (enableBlockStatModification) {
                bronzeBlockHardness = (float)settings.get("Block Stats", "Bronze Block Hardness", 7.0).getDouble((double)bronzeBlockHardness);
                bronzeBlockResistance = (float)settings.get("Block Stats", "Bronze Block Resistance", 12.0).getDouble((double)bronzeBlockResistance);
                thyriumBlockHardness = (float)settings.get("Block Stats", "Thyrium Block Hardness", 7.0).getDouble((double)thyriumBlockHardness);
                thyriumBlockResistance = (float)settings.get("Block Stats", "Thyrium Block Resistance", 12.0).getDouble((double)thyriumBlockResistance);
                sinisiteBlockHardness = (float)settings.get("Block Stats", "Sinisite Block Hardness", 7.0).getDouble((double)sinisiteBlockHardness);
                sinisiteBlockResistance = (float)settings.get("Block Stats", "Sinisite Block Resistance", 12.0).getDouble((double)sinisiteBlockResistance);
                fusionFurnaceHardness = (float)settings.get("Block Stats", "Fusion Furnace Hardness", 3.5).getDouble((double)fusionFurnaceHardness);
                fusionFurnaceResistance = (float)settings.get("Block Stats", "Fusion Furnace Resistance", 10.0).getDouble((double)fusionFurnaceResistance);
                fusionFurnaceLightValue = (float)settings.get("Block Stats", "Fusion Furnace Light Value", 1.0).getDouble((double)fusionFurnaceLightValue);
            } else {
                Settings.defaultBlockStats();
            }
            if (enableCustomFusionRecipes) {
                String example = "simpleores:copper_ore@0#2, minecraft:dye@15#1, minecraft:dye@ALL#3, simpleores:adamantium_helmet@0#2, 5.80";
                settings.addCustomCategoryComment("Custom Fusion Recipes", "Instructions: Change 'Number of Custom Recipes' to how many recipes you want. Restart game. Fill each 'Recipe #X' with your custom recipe. Format: input1, input2, catalyst, output, experience. Each item is in format: modid:item@metadata. Experience is a double, so 1.00, 10.76, etc. are all accepted. For metadata, type ALL if you want any subtype of that item to be usable (AKA Wildcard Value). See the example.");
                recipeNum = settings.get("Custom Fusion Recipes", "Number of Custom Recipes", 0).getInt();
                exampleRecipe = settings.get("Custom Fusion Recipes", "Example Recipe (isn't actually loaded)", example).getString();
                if (recipeNum > 0) {
                    for (int i = 0; i < recipeNum; ++i) {
                        settings.get("Custom Fusion Recipes", "Custom Recipe #" + (i + 1), new String()).getString();
                    }
                }
            }
            LogHelper.verboseInfo("Fusion Plugin: Settings file loaded successfully.");
        }
        catch (Exception e) {
            LogHelper.info("Fusion Plugin: Failed to load the Settings file.");
        }
        finally {
            settings.save();
        }
    }

    public static void defaultToolStats() {
        bronzeMiningLevel = 2;
        bronzeUsesNum = 600;
        bronzeMiningSpeed = 9.0f;
        bronzeDamageVsEntity = 2;
        bronzeEnchantability = 7;
        thyriumMiningLevel = 3;
        thyriumUsesNum = 2000;
        thyriumMiningSpeed = 22.0f;
        thyriumDamageVsEntity = 6;
        thyriumEnchantability = 28;
        sinisiteMiningLevel = 5;
        sinisiteUsesNum = 4100;
        sinisiteMiningSpeed = 18.0f;
        sinisiteDamageVsEntity = 8;
        sinisiteEnchantability = 11;
    }

    public static void defaultArmorStats() {
        bronzeArmorDurability = 16;
        bronzeArmorDamageReduction = new int[]{3, 5, 3, 1};
        bronzeArmorEnchantability = 7;
        thyriumArmorDurability = 39;
        thyriumArmorDamageReduction = new int[]{4, 8, 7, 4};
        thyriumArmorEnchantability = 28;
        sinisiteArmorDurability = 56;
        sinisiteArmorDamageReduction = new int[]{6, 8, 8, 7};
        sinisiteArmorEnchantability = 11;
    }

    public static void defaultBlockStats() {
        bronzeBlockHardness = 7.0f;
        bronzeBlockResistance = 12.0f;
        thyriumBlockHardness = 7.0f;
        thyriumBlockResistance = 12.0f;
        sinisiteBlockHardness = 7.0f;
        sinisiteBlockResistance = 12.0f;
        fusionFurnaceHardness = 3.5f;
        fusionFurnaceResistance = 10.0f;
        fusionFurnaceLightValue = 1.0f;
    }
}

