/*
 * Decompiled with CFR 0.152.
 */
package alexndr.SimpleOres.plugins.fusion;

import alexndr.SimpleOres.api.helpers.LogHelper;
import alexndr.SimpleOres.plugins.fusion.Content;
import alexndr.SimpleOres.plugins.fusion.FusionRecipes;
import alexndr.SimpleOres.plugins.fusion.Settings;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class Recipes {
    private static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void preInitialize() {
        try {
            Recipes.doOreDictRecipes();
            LogHelper.verboseInfo("Fusion Plugin: All OreDictionary entries were added successfully.");
        }
        catch (Exception e) {
            LogHelper.severe("Fusion Plugin: OreDictionary entries were not added successfully. This is a serious problem!");
            e.printStackTrace();
        }
    }

    public static void initialize() {
        try {
            Recipes.doRecipes();
            LogHelper.verboseInfo("Fusion Plugin: All recipes were added successfully.");
        }
        catch (Exception e) {
            LogHelper.severe("Fusion Plugin: Recipes were not added successfully. This is a serious problem!");
            e.printStackTrace();
        }
    }

    public static void postInitialize() {
        if (Settings.enableCustomFusionRecipes) {
            try {
                Recipes.addCustomFusionRecipes();
                LogHelper.verboseInfo("Fusion Plugin: All custom Fusion Furnace recipes (if any) were added successfully.");
            }
            catch (Exception e) {
                LogHelper.severe("Fusion Plugin: Custom Fusion Furnace recipes (if any) were not added successfully. This is a serious problem!");
                e.printStackTrace();
            }
        }
    }

    public static void doOreDictRecipes() {
        OreDictionary.registerOre((String)"ingotBronze", (ItemStack)new ItemStack(Content.bronze_ingot));
        OreDictionary.registerOre((String)"ingotThyrium", (ItemStack)new ItemStack(Content.thyrium_ingot));
        OreDictionary.registerOre((String)"ingotSinisite", (ItemStack)new ItemStack(Content.sinisite_ingot));
        OreDictionary.registerOre((String)"blockBronze", (ItemStack)new ItemStack(Content.bronze_block));
        OreDictionary.registerOre((String)"blockThyrium", (ItemStack)new ItemStack(Content.thyrium_block));
        OreDictionary.registerOre((String)"blockSinisite", (ItemStack)new ItemStack(Content.sinisite_block));
    }

    public static void doRecipes() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.bronze_block, new Object[]{true, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "ingotBronze"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.thyrium_block, new Object[]{true, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "ingotThyrium"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.sinisite_block, new Object[]{true, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "ingotSinisite"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.fusion_furnace, new Object[]{true, new Object[]{"XWX", "ZYZ", "XWX", Character.valueOf('X'), Blocks.field_150336_V, Character.valueOf('Y'), Blocks.field_150460_al, Character.valueOf('W'), Items.field_151044_h, Character.valueOf('Z'), Items.field_151042_j}}));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.bronze_ingot, 9), (Object[])new Object[]{Content.bronze_block});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.thyrium_ingot, 9), (Object[])new Object[]{Content.thyrium_block});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.sinisite_ingot, 9), (Object[])new Object[]{Content.sinisite_block});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.large_bronze_chunk, 1), (Object[])new Object[]{Content.small_bronze_chunk, Content.small_bronze_chunk, Content.small_bronze_chunk, Content.small_bronze_chunk, Content.small_bronze_chunk});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.large_bronze_chunk, 1), (Object[])new Object[]{Content.medium_bronze_chunk, Content.medium_bronze_chunk, Content.medium_bronze_chunk});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.large_thyrium_chunk, 1), (Object[])new Object[]{Content.small_thyrium_chunk, Content.small_thyrium_chunk, Content.small_thyrium_chunk, Content.small_thyrium_chunk, Content.small_thyrium_chunk});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.large_thyrium_chunk, 1), (Object[])new Object[]{Content.medium_thyrium_chunk, Content.medium_thyrium_chunk, Content.medium_thyrium_chunk});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.large_sinisite_chunk, 1), (Object[])new Object[]{Content.small_sinisite_chunk, Content.small_sinisite_chunk, Content.small_sinisite_chunk, Content.small_sinisite_chunk, Content.small_sinisite_chunk});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.large_sinisite_chunk, 1), (Object[])new Object[]{Content.medium_sinisite_chunk, Content.medium_sinisite_chunk, Content.medium_sinisite_chunk});
        if (Settings.enableExtraChunkRecipes) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.large_bronze_chunk, 1), (Object[])new Object[]{Content.small_bronze_chunk, Content.small_bronze_chunk, Content.medium_bronze_chunk, Content.medium_bronze_chunk});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.medium_bronze_chunk, 1), (Object[])new Object[]{Content.small_bronze_chunk, Content.small_bronze_chunk, Content.small_bronze_chunk});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.medium_bronze_chunk, 2), (Object[])new Object[]{Content.large_bronze_chunk});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.small_bronze_chunk, 2), (Object[])new Object[]{Content.medium_bronze_chunk});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.large_thyrium_chunk, 1), (Object[])new Object[]{Content.small_thyrium_chunk, Content.small_thyrium_chunk, Content.medium_thyrium_chunk, Content.medium_thyrium_chunk});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.medium_thyrium_chunk, 1), (Object[])new Object[]{Content.small_thyrium_chunk, Content.small_thyrium_chunk, Content.small_thyrium_chunk});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.medium_thyrium_chunk, 2), (Object[])new Object[]{Content.large_thyrium_chunk});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.small_thyrium_chunk, 2), (Object[])new Object[]{Content.medium_thyrium_chunk});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.large_sinisite_chunk, 1), (Object[])new Object[]{Content.small_sinisite_chunk, Content.small_sinisite_chunk, Content.medium_sinisite_chunk, Content.medium_sinisite_chunk});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.medium_sinisite_chunk, 1), (Object[])new Object[]{Content.small_sinisite_chunk, Content.small_sinisite_chunk, Content.small_sinisite_chunk});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.medium_sinisite_chunk, 2), (Object[])new Object[]{Content.large_sinisite_chunk});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Content.small_sinisite_chunk, 2), (Object[])new Object[]{Content.medium_sinisite_chunk});
        }
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.thyrium_rod, new Object[]{true, new Object[]{"X", "X", Character.valueOf('X'), "ingotThyrium"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.sinisite_rod, new Object[]{true, new Object[]{"X", "X", Character.valueOf('X'), "ingotSinisite"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.bronze_pickaxe, new Object[]{true, new Object[]{"XXX", " Y ", " Y ", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.bronze_axe, new Object[]{true, new Object[]{"XX ", "XY ", " Y ", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.bronze_shovel, new Object[]{true, new Object[]{"X", "Y", "Y", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.bronze_sword, new Object[]{true, new Object[]{"X", "X", "Y", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.bronze_hoe, new Object[]{true, new Object[]{"XX ", " Y ", " Y ", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.thyrium_pickaxe, new Object[]{true, new Object[]{"XXX", " Y ", " Y ", Character.valueOf('X'), "ingotThyrium", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.thyrium_axe, new Object[]{true, new Object[]{"XX ", "XY ", " Y ", Character.valueOf('X'), "ingotThyrium", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.thyrium_shovel, new Object[]{true, new Object[]{"X", "Y", "Y", Character.valueOf('X'), "ingotThyrium", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.thyrium_sword, new Object[]{true, new Object[]{"X", "X", "Y", Character.valueOf('X'), "ingotThyrium", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.thyrium_hoe, new Object[]{true, new Object[]{"XX ", " Y ", " Y ", Character.valueOf('X'), "ingotThyrium", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.sinisite_pickaxe, new Object[]{true, new Object[]{"XXX", " Y ", " Y ", Character.valueOf('X'), "ingotSinisite", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.sinisite_axe, new Object[]{true, new Object[]{"XX ", "XY ", " Y ", Character.valueOf('X'), "ingotSinisite", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.sinisite_shovel, new Object[]{true, new Object[]{"X", "Y", "Y", Character.valueOf('X'), "ingotSinisite", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.sinisite_sword, new Object[]{true, new Object[]{"X", "X", "Y", Character.valueOf('X'), "ingotSinisite", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.sinisite_hoe, new Object[]{true, new Object[]{"XX ", " Y ", " Y ", Character.valueOf('X'), "ingotSinisite", Character.valueOf('Y'), "stickWood"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.thyrium_bow, new Object[]{true, new Object[]{" XY", "Z Y", " XY", Character.valueOf('X'), Content.thyrium_rod, Character.valueOf('Y'), Items.field_151007_F, Character.valueOf('Z'), Items.field_151043_k}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.sinisite_bow, new Object[]{true, new Object[]{" XY", "Z Y", " XY", Character.valueOf('X'), Content.sinisite_rod, Character.valueOf('Y'), Items.field_151007_F, Character.valueOf('Z'), "gemOnyx"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.bronze_helmet, new Object[]{true, new Object[]{"XXX", "X X", Character.valueOf('X'), "ingotBronze"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.bronze_chestplate, new Object[]{true, new Object[]{"X X", "XXX", "XXX", Character.valueOf('X'), "ingotBronze"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.bronze_leggings, new Object[]{true, new Object[]{"XXX", "X X", "X X", Character.valueOf('X'), "ingotBronze"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.bronze_boots, new Object[]{true, new Object[]{"X X", "X X", Character.valueOf('X'), "ingotBronze"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.thyrium_helmet, new Object[]{true, new Object[]{"XXX", "X X", Character.valueOf('X'), "ingotThyrium"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.thyrium_chestplate, new Object[]{true, new Object[]{"X X", "XXX", "XXX", Character.valueOf('X'), "ingotThyrium"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.thyrium_leggings, new Object[]{true, new Object[]{"XXX", "X X", "X X", Character.valueOf('X'), "ingotThyrium"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.thyrium_boots, new Object[]{true, new Object[]{"X X", "X X", Character.valueOf('X'), "ingotThyrium"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.sinisite_helmet, new Object[]{true, new Object[]{"XXX", "X X", Character.valueOf('X'), "ingotSinisite"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.sinisite_chestplate, new Object[]{true, new Object[]{"X X", "XXX", "XXX", Character.valueOf('X'), "ingotSinisite"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.sinisite_leggings, new Object[]{true, new Object[]{"XXX", "X X", "X X", Character.valueOf('X'), "ingotSinisite"}}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(Content.sinisite_boots, new Object[]{true, new Object[]{"X X", "X X", Character.valueOf('X'), "ingotSinisite"}}));
        FusionRecipes.addSmelting(new ItemStack(alexndr.SimpleOres.core.Content.copper_ingot), new ItemStack(alexndr.SimpleOres.core.Content.tin_ingot), new ItemStack(Items.field_151100_aR, 1, 15), new ItemStack(Content.small_bronze_chunk), 2.0f);
        FusionRecipes.addSmelting(new ItemStack(alexndr.SimpleOres.core.Content.copper_ingot), new ItemStack(alexndr.SimpleOres.core.Content.tin_ingot), new ItemStack(Items.field_151016_H), new ItemStack(Content.medium_bronze_chunk), 3.0f);
        FusionRecipes.addSmelting(new ItemStack(alexndr.SimpleOres.core.Content.copper_ingot), new ItemStack(alexndr.SimpleOres.core.Content.tin_ingot), new ItemStack(Items.field_151137_ax), new ItemStack(Content.large_bronze_chunk), 10.0f);
        FusionRecipes.addSmelting(new ItemStack(alexndr.SimpleOres.core.Content.mythril_ingot), new ItemStack(alexndr.SimpleOres.core.Content.adamantium_ingot), new ItemStack(Items.field_151137_ax), new ItemStack(Content.small_thyrium_chunk), 6.0f);
        FusionRecipes.addSmelting(new ItemStack(alexndr.SimpleOres.core.Content.mythril_ingot), new ItemStack(alexndr.SimpleOres.core.Content.adamantium_ingot), new ItemStack(Items.field_151100_aR, 1, 4), new ItemStack(Content.medium_thyrium_chunk), 10.0f);
        FusionRecipes.addSmelting(new ItemStack(alexndr.SimpleOres.core.Content.mythril_ingot), new ItemStack(alexndr.SimpleOres.core.Content.adamantium_ingot), new ItemStack(Items.field_151114_aO), new ItemStack(Content.large_thyrium_chunk), 30.0f);
        FusionRecipes.addSmelting(new ItemStack(alexndr.SimpleOres.core.Content.onyx_gem), new ItemStack(alexndr.SimpleOres.core.Content.mythril_ingot), new ItemStack(Items.field_151114_aO), new ItemStack(Content.small_sinisite_chunk), 12.0f);
        FusionRecipes.addSmelting(new ItemStack(alexndr.SimpleOres.core.Content.onyx_gem), new ItemStack(alexndr.SimpleOres.core.Content.mythril_ingot), new ItemStack(Items.field_151065_br), new ItemStack(Content.medium_sinisite_chunk), 20.0f);
        FusionRecipes.addSmelting(new ItemStack(alexndr.SimpleOres.core.Content.onyx_gem), new ItemStack(alexndr.SimpleOres.core.Content.mythril_ingot), new ItemStack(Items.field_151073_bk), new ItemStack(Content.large_sinisite_chunk), 60.0f);
        GameRegistry.addSmelting((Item)Content.large_bronze_chunk, (ItemStack)new ItemStack(Content.bronze_ingot, 1, 0), (float)0.3f);
        GameRegistry.addSmelting((Item)Content.large_thyrium_chunk, (ItemStack)new ItemStack(Content.thyrium_ingot, 1, 0), (float)0.6f);
        GameRegistry.addSmelting((Item)Content.large_sinisite_chunk, (ItemStack)new ItemStack(Content.sinisite_ingot, 1, 0), (float)1.0f);
    }

    public static void addCustomFusionRecipes() {
        int recipeNum = Settings.recipeNum;
        if (recipeNum > 0) {
            for (int i = 0; i < recipeNum; ++i) {
                String recipe = Settings.settings.get("Custom Fusion Recipes", "Custom Recipe #" + (i + 1), new String()).getString();
                if (recipe == null) continue;
                ArrayList recipeParts = Lists.newArrayList((Iterable)Splitter.on((char)',').trimResults().split((CharSequence)recipe));
                Item input1 = (Item)Item.field_150901_e.func_82594_a(((String)Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)recipeParts.get(0).toString())).get(0)).toString());
                String meta1String = ((String)Lists.newArrayList((Iterable)Splitter.on((char)'#').split((CharSequence)((String)Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)recipeParts.get(0).toString())).get(1)).toString())).get(0)).toString();
                int meta1 = meta1String.equals("ALL") ? Short.MAX_VALUE : Integer.parseInt(meta1String);
                int size1 = Integer.parseInt(((String)Lists.newArrayList((Iterable)Splitter.on((char)'#').split((CharSequence)((String)Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)recipeParts.get(0).toString())).get(1)).toString())).get(1)).toString());
                Item input2 = (Item)Item.field_150901_e.func_82594_a(((String)Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)recipeParts.get(1).toString())).get(0)).toString());
                String meta2String = ((String)Lists.newArrayList((Iterable)Splitter.on((char)'#').split((CharSequence)((String)Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)recipeParts.get(1).toString())).get(1)).toString())).get(0)).toString();
                int meta2 = meta2String.equals("ALL") ? Short.MAX_VALUE : Integer.parseInt(meta2String);
                int size2 = Integer.parseInt(((String)Lists.newArrayList((Iterable)Splitter.on((char)'#').split((CharSequence)((String)Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)recipeParts.get(1).toString())).get(1)).toString())).get(1)).toString());
                Item catalyst = (Item)Item.field_150901_e.func_82594_a(((String)Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)recipeParts.get(2).toString())).get(0)).toString());
                String catalystMetaString = ((String)Lists.newArrayList((Iterable)Splitter.on((char)'#').split((CharSequence)((String)Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)recipeParts.get(2).toString())).get(1)).toString())).get(0)).toString();
                int catalystMeta = catalystMetaString.equals("ALL") ? Short.MAX_VALUE : Integer.parseInt(catalystMetaString);
                int catalystSize = Integer.parseInt(((String)Lists.newArrayList((Iterable)Splitter.on((char)'#').split((CharSequence)((String)Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)recipeParts.get(2).toString())).get(1)).toString())).get(1)).toString());
                Item output = (Item)Item.field_150901_e.func_82594_a(((String)Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)recipeParts.get(3).toString())).get(0)).toString());
                String outputMetaString = ((String)Lists.newArrayList((Iterable)Splitter.on((char)'#').split((CharSequence)((String)Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)recipeParts.get(3).toString())).get(1)).toString())).get(0)).toString();
                int outputMeta = outputMetaString.equals("ALL") ? Short.MAX_VALUE : Integer.parseInt(outputMetaString);
                int outputSize = Integer.parseInt(((String)Lists.newArrayList((Iterable)Splitter.on((char)'#').split((CharSequence)((String)Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)recipeParts.get(3).toString())).get(1)).toString())).get(1)).toString());
                Float experience = Float.valueOf((float)Double.parseDouble(recipeParts.get(4).toString()));
                FusionRecipes.addSmelting(new ItemStack(input1, size1, meta1), new ItemStack(input2, size2, meta2), new ItemStack(catalyst, catalystSize, catalystMeta), new ItemStack(output, outputSize, outputMeta), experience.floatValue());
            }
        }
    }
}

