/*
 * Decompiled with CFR 0.152.
 */
package alexndr.SimpleOres.plugins.fusion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class FusionRecipes {
    private static final ArrayList<Entry> recipeList = Lists.newArrayList();
    private static final HashMap<ItemStack, Float> experienceMap = new HashMap();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void addSmelting(Material input1, Material input2, Material catalyst, ItemStack output, float experience) {
        recipeList.add(new BasicEntry(input1, input2, catalyst, output));
        FusionRecipes.setExperience(output.func_77946_l(), experience);
    }

    public static void addSmelting(ItemStack input1, ItemStack input2, ItemStack catalyst, ItemStack output, float experience) {
        recipeList.add(new BasicEntry(input1, input2, catalyst, output));
        FusionRecipes.setExperience(output.func_77946_l(), experience);
    }

    public static ItemStack getSmeltingResult(ItemStack input1, ItemStack input2, ItemStack catalyst) {
        for (Entry e : recipeList) {
            if (!e.matches(input1, input2, catalyst)) continue;
            return e.getOutput(input1, input2, catalyst);
        }
        return null;
    }

    public static void setExperience(ItemStack output, float experience) {
        if (!experienceMap.containsKey(output)) {
            experienceMap.put(output.func_77946_l(), Float.valueOf(experience));
        }
    }

    public static ItemStack applyFusion(ItemStack input1, ItemStack input2, ItemStack catalyst) {
        for (Entry e : recipeList) {
            if (!e.matches(input1, input2, catalyst)) continue;
            return e.applyFusion(input1, input2, catalyst);
        }
        return null;
    }

    public static float getExperience(ItemStack item) {
        Float exp = experienceMap.get(item);
        return exp == null ? 0.0f : exp.floatValue();
    }

    public static boolean isItemCatalyst(ItemStack item) {
        for (Entry e : recipeList) {
            if (!e.isItemCatalyst(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemInput(ItemStack item) {
        for (Entry e : recipeList) {
            if (!e.isItemInput(item)) continue;
            return true;
        }
        return false;
    }

    public static List<Entry> getRecipeList() {
        return recipeList;
    }

    public static Map<ItemStack, Float> getExperienceList() {
        return experienceMap;
    }

    public static int size() {
        return recipeList.size();
    }

    public static boolean matches(ItemStack target, ItemStack stack) {
        return target.func_77973_b() == stack.func_77973_b() && (target.func_77960_j() == stack.func_77960_j() || target.func_77960_j() == Short.MAX_VALUE);
    }

    public static class StackMaterial
    extends Material {
        private final ItemStack stack;

        public ItemStack getStack() {
            return this.stack.func_77946_l();
        }

        private StackMaterial(ItemStack stack) {
            if (stack.field_77994_a < 0) {
                throw new IllegalArgumentException(stack.toString());
            }
            this.stack = stack.func_77946_l();
        }

        @Override
        public boolean matches(ItemStack item) {
            if (item == null || item.field_77994_a < this.stack.field_77994_a) {
                return false;
            }
            return FusionRecipes.matches(this.stack, item);
        }

        @Override
        public void decrStackSize(ItemStack item) {
            item.field_77994_a -= this.stack.field_77994_a;
        }

        @Override
        public List<ItemStack> items() {
            return Lists.newArrayList((Object[])new ItemStack[]{this.stack.func_77946_l()});
        }
    }

    public static class OreMaterial
    extends Material {
        public final String ore;
        public final int amount;

        private OreMaterial(String ore, int amount) {
            if (amount < 0) {
                throw new IllegalArgumentException(Integer.valueOf(amount).toString());
            }
            this.ore = ore;
            this.amount = amount;
        }

        @Override
        public boolean matches(ItemStack item) {
            if (item == null || item.field_77994_a < this.amount) {
                return false;
            }
            for (ItemStack stack : OreDictionary.getOres((String)this.ore)) {
                if (!FusionRecipes.matches(stack, item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void decrStackSize(ItemStack item) {
            item.field_77994_a -= this.amount;
        }

        @Override
        public List<ItemStack> items() {
            return OreDictionary.getOres((String)this.ore);
        }
    }

    public static class NullMaterial
    extends Material {
        private NullMaterial() {
        }

        @Override
        public boolean matches(ItemStack item) {
            return item == null;
        }

        @Override
        public void decrStackSize(ItemStack item) {
        }

        @Override
        public List<ItemStack> items() {
            return Lists.newArrayList();
        }
    }

    public static abstract class Material {
        public static Material of() {
            return new NullMaterial();
        }

        public static Material of(String ore, int amount) {
            return new OreMaterial(ore, amount);
        }

        public static Material of(ItemStack stack) {
            return new StackMaterial(stack);
        }

        public static Material of(Item item, int amount, int meta) {
            return Material.of(new ItemStack(item, amount, meta));
        }

        public static Material of(Item item, int amount) {
            return Material.of(item, amount, 0);
        }

        public static Material of(Item item) {
            return Material.of(item, 1, 0);
        }

        public static Material of(Block block, int amount, int meta) {
            return Material.of(new ItemStack(block, amount, meta));
        }

        public static Material of(Block block, int amount) {
            return Material.of(block, amount, 0);
        }

        public static Material of(Block block) {
            return Material.of(block, 1, 0);
        }

        public static Material of(String ore) {
            return Material.of(ore, 1);
        }

        public abstract boolean matches(ItemStack var1);

        public abstract void decrStackSize(ItemStack var1);

        public abstract List<ItemStack> items();
    }

    public static class EntryInfo {
        public final Material input1;
        public final Material input2;
        public final Material catalyst;
        public final Material output;

        public EntryInfo(Material input1, Material input2, Material catalyst, Material output) {
            this.input1 = input1;
            this.input2 = input2;
            this.catalyst = catalyst;
            this.output = output;
        }
    }

    public static class BasicEntry
    implements Entry {
        public final Material input1;
        public final Material input2;
        public final Material catalyst;
        private final ItemStack output;

        public BasicEntry(Material input1, Material input2, Material catalyst, ItemStack output) {
            this.input1 = input1;
            this.input2 = input2;
            this.catalyst = catalyst;
            this.output = output.func_77946_l();
        }

        public BasicEntry(ItemStack input1, ItemStack input2, ItemStack catalyst, ItemStack output) {
            this.input1 = Material.of(input1);
            this.input2 = Material.of(input2);
            this.catalyst = Material.of(catalyst);
            this.output = output.func_77946_l();
        }

        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        @Override
        public boolean matches(ItemStack input1, ItemStack input2, ItemStack catalyst) {
            return this.catalyst.matches(catalyst) && (this.input1.matches(input1) && this.input2.matches(input2) || this.input1.matches(input2) && this.input2.matches(input1));
        }

        @Override
        public ItemStack getOutput(ItemStack input1, ItemStack input2, ItemStack catalyst) {
            return this.output.func_77946_l();
        }

        @Override
        public ItemStack applyFusion(ItemStack input1, ItemStack input2, ItemStack catalyst) {
            if (this.input1.matches(input1) && this.input2.matches(input2)) {
                this.input1.decrStackSize(input1);
                this.input2.decrStackSize(input2);
            } else {
                this.input1.decrStackSize(input2);
                this.input2.decrStackSize(input1);
            }
            this.catalyst.decrStackSize(catalyst);
            return this.output.func_77946_l();
        }

        @Override
        public boolean isItemInput(ItemStack item) {
            return this.input1.matches(item) || this.input2.matches(item);
        }

        @Override
        public boolean isItemCatalyst(ItemStack item) {
            return this.catalyst.matches(item);
        }

        @Override
        public EntryInfo getInfo() {
            return new EntryInfo(this.input1, this.input2, this.catalyst, Material.of(this.output));
        }
    }

    public static interface Entry {
        public boolean matches(ItemStack var1, ItemStack var2, ItemStack var3);

        public ItemStack getOutput(ItemStack var1, ItemStack var2, ItemStack var3);

        public ItemStack applyFusion(ItemStack var1, ItemStack var2, ItemStack var3);

        public boolean isItemInput(ItemStack var1);

        public boolean isItemCatalyst(ItemStack var1);

        public EntryInfo getInfo();
    }
}

