/*
 * Decompiled with CFR 0.152.
 */
package alexndr.SimpleOres.plugins.fusion;

import alexndr.SimpleOres.api.helpers.LogHelper;
import alexndr.SimpleOres.api.helpers.StatTriggersHelper;
import alexndr.SimpleOres.api.helpers.UpdateCheckerHelper;
import alexndr.SimpleOres.core.SimpleOres;
import alexndr.SimpleOres.plugins.fusion.Content;
import alexndr.SimpleOres.plugins.fusion.FusionFurnaceTileEntity;
import alexndr.SimpleOres.plugins.fusion.FusionRecipes;
import alexndr.SimpleOres.plugins.fusion.ProxyCommon;
import alexndr.SimpleOres.plugins.fusion.Recipes;
import alexndr.SimpleOres.plugins.fusion.Settings;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;

@Mod(modid="fusionplugin", name="SimpleOres 2 Fusion Plugin", version="1.4.0", dependencies="required-after:simpleores")
public class FusionPlugin {
    @SidedProxy(clientSide="alexndr.SimpleOres.plugins.fusion.ProxyClient", serverSide="alexndr.SimpleOres.plugins.fusion.ProxyCommon")
    public static ProxyCommon proxy;
    public static FusionPlugin INSTANCE;
    public static Item.ToolMaterial toolBronze;
    public static Item.ToolMaterial toolThyrium;
    public static Item.ToolMaterial toolSinisite;
    public static ItemArmor.ArmorMaterial armorBronze;
    public static ItemArmor.ArmorMaterial armorThyrium;
    public static ItemArmor.ArmorMaterial armorSinisite;
    public static int rendererBronze;
    public static int rendererThyrium;
    public static int rendererSinisite;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.registerClientTickHandler();
        Settings.doSettings(event);
        FusionPlugin.setToolsAndArmorStats();
        Content.initialize();
        Recipes.preInitialize();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        INSTANCE = this;
        Recipes.initialize();
        FusionPlugin.setAchievementTriggers();
        if (alexndr.SimpleOres.core.Settings.enableUpdateChecker) {
            UpdateCheckerHelper.checkUpdates("http://dl.dropboxusercontent.com/u/66466201/SimpleOres/Fusion/Fusion%20Plugin%20Version.txt", "fusionplugin", "1.4.0");
        }
        GameRegistry.registerTileEntity(FusionFurnaceTileEntity.class, (String)"fusionFurnace");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)proxy);
        rendererBronze = SimpleOres.proxy.addArmor("bronze");
        rendererThyrium = SimpleOres.proxy.addArmor("thyrium");
        rendererSinisite = SimpleOres.proxy.addArmor("sinisite");
        FusionPlugin.toolBronze.customCraftingMaterial = Content.bronze_ingot;
        FusionPlugin.toolThyrium.customCraftingMaterial = Content.thyrium_ingot;
        FusionPlugin.toolSinisite.customCraftingMaterial = Content.sinisite_ingot;
        FusionPlugin.armorBronze.customCraftingMaterial = Content.bronze_ingot;
        FusionPlugin.armorThyrium.customCraftingMaterial = Content.thyrium_ingot;
        FusionPlugin.armorSinisite.customCraftingMaterial = Content.sinisite_ingot;
        LogHelper.info("Fusion Plugin: " + FusionRecipes.size() / 2 + " Fusion Furnace recipes were loaded.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Recipes.postInitialize();
        LogHelper.info("Plugin Loader: Fusion Plugin loaded successfully.");
    }

    public static void setToolsAndArmorStats() {
        toolBronze = EnumHelper.addToolMaterial((String)"BRONZE", (int)Settings.bronzeMiningLevel, (int)Settings.bronzeUsesNum, (float)Settings.bronzeMiningSpeed, (float)Settings.bronzeDamageVsEntity, (int)Settings.bronzeEnchantability);
        toolThyrium = EnumHelper.addToolMaterial((String)"THYRIUM", (int)Settings.thyriumMiningLevel, (int)Settings.thyriumUsesNum, (float)Settings.thyriumMiningSpeed, (float)Settings.thyriumDamageVsEntity, (int)Settings.thyriumEnchantability);
        toolSinisite = EnumHelper.addToolMaterial((String)"SINISITE", (int)Settings.sinisiteMiningLevel, (int)Settings.sinisiteUsesNum, (float)Settings.sinisiteMiningSpeed, (float)Settings.sinisiteDamageVsEntity, (int)Settings.sinisiteEnchantability);
        armorBronze = EnumHelper.addArmorMaterial((String)"BRONZE", (int)Settings.bronzeArmorDurability, (int[])Settings.bronzeArmorDamageReduction, (int)Settings.bronzeArmorEnchantability);
        armorThyrium = EnumHelper.addArmorMaterial((String)"THYRIUM", (int)Settings.thyriumArmorDurability, (int[])Settings.thyriumArmorDamageReduction, (int)Settings.thyriumArmorEnchantability);
        armorSinisite = EnumHelper.addArmorMaterial((String)"SINISITE", (int)Settings.sinisiteArmorDurability, (int[])Settings.sinisiteArmorDamageReduction, (int)Settings.sinisiteArmorEnchantability);
    }

    public static void setAchievementTriggers() {
        StatTriggersHelper.statTriggers().addCraftingTrigger(new ItemStack(Content.fusion_furnace), Content.fusionAch);
        StatTriggersHelper.statTriggers().addSmeltingTrigger(new ItemStack(Content.bronze_ingot), Content.bronzeAch);
    }

    static {
        INSTANCE = new FusionPlugin();
    }
}

