/*
 * Decompiled with CFR 0.152.
 */
package alexndr.SimpleOres.core.helpers;

import alexndr.SimpleOres.api.helpers.WorldGenHelper;
import alexndr.SimpleOres.core.Content;
import alexndr.SimpleOres.core.Settings;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class Generator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == -1) {
            this.generateNether(world, random, chunkX * 16, chunkZ * 16);
        }
        if (world.field_73011_w.field_76574_g == 0) {
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
        }
        if (Settings.enableCustomGeneration && Settings.numCustomGenerationRules > 0) {
            for (int i = 0; i < Settings.numCustomGenerationRules; ++i) {
                String customRule = Settings.settings.get("Custom Generation Rules", "Custom Rule #" + (i + 1), new String()).getString();
                if (world.field_73011_w.field_76574_g != this.splitCustomRuleInts(customRule, "dimensionId")) continue;
                this.generateHigher(customRule, world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateSurface(World world, Random random, int blockX, int blockZ) {
        int Zcoord;
        int Ycoord;
        int Xcoord;
        int x;
        for (x = 0; x < Settings.copperSpawnRate; ++x) {
            Xcoord = blockX + random.nextInt(16);
            Ycoord = random.nextInt(Settings.copperMaxHeight - Settings.copperMinHeight);
            Zcoord = blockZ + random.nextInt(16);
            new WorldGenHelper(Content.copper_ore, Settings.copperVeinSize, Blocks.field_150348_b).func_76484_a(world, random, Xcoord, Ycoord + Settings.copperMinHeight, Zcoord);
        }
        for (x = 0; x < Settings.tinSpawnRate; ++x) {
            Xcoord = blockX + random.nextInt(16);
            Ycoord = random.nextInt(Settings.tinMaxHeight - Settings.tinMinHeight);
            Zcoord = blockZ + random.nextInt(16);
            new WorldGenHelper(Content.tin_ore, Settings.tinVeinSize, Blocks.field_150348_b).func_76484_a(world, random, Xcoord, Ycoord + Settings.tinMinHeight, Zcoord);
        }
        for (x = 0; x < Settings.mythrilSpawnRate; ++x) {
            Xcoord = blockX + random.nextInt(16);
            Ycoord = random.nextInt(Settings.mythrilMaxHeight - Settings.mythrilMinHeight);
            Zcoord = blockZ + random.nextInt(16);
            new WorldGenHelper(Content.mythril_ore, Settings.mythrilVeinSize, Blocks.field_150348_b).func_76484_a(world, random, Xcoord, Ycoord + Settings.mythrilMinHeight, Zcoord);
        }
        for (x = 0; x < Settings.adamantiumSpawnRate; ++x) {
            Xcoord = blockX + random.nextInt(16);
            Ycoord = random.nextInt(Settings.adamantiumMaxHeight - Settings.adamantiumMinHeight);
            Zcoord = blockZ + random.nextInt(16);
            new WorldGenHelper(Content.adamantium_ore, Settings.adamantiumVeinSize, Blocks.field_150348_b).func_76484_a(world, random, Xcoord, Ycoord + Settings.adamantiumMinHeight, Zcoord);
        }
    }

    private void generateNether(World world, Random rand, int baseX, int baseZ) {
        for (int i = 0; i < Settings.onyxSpawnRate; ++i) {
            int randPosX = baseX + rand.nextInt(16);
            int randPosY = rand.nextInt(Settings.onyxMaxHeight - Settings.onyxMinHeight);
            int randPosZ = baseZ + rand.nextInt(16);
            new WorldGenHelper(Content.onyx_ore, Settings.onyxVeinSize, Blocks.field_150424_aL).func_76484_a(world, rand, randPosX, randPosY + Settings.onyxMinHeight, randPosZ);
        }
    }

    private void generateHigher(String customRule, World world, Random random, int blockX, int blockZ) {
        if (Settings.enableCustomGeneration) {
            int spawnRate = this.splitCustomRuleInts(customRule, "spawnRate");
            int maxHeight = this.splitCustomRuleInts(customRule, "maxHeight");
            int minHeight = this.splitCustomRuleInts(customRule, "minHeight");
            int veinSize = this.splitCustomRuleInts(customRule, "veinSize");
            Block hostBlock = this.splitCustomRuleBlocks(customRule, "hostBlock");
            Block spawningBlock = this.splitCustomRuleBlocks(customRule, "spawningBlock");
            for (int i = 0; i < spawnRate; ++i) {
                int Xcoord = blockX + random.nextInt(16);
                int Ycoord = random.nextInt(maxHeight - minHeight);
                int Zcoord = blockZ + random.nextInt(16);
                new WorldGenHelper(spawningBlock, veinSize, hostBlock).func_76484_a(world, random, Xcoord, Ycoord + minHeight, Zcoord);
            }
        }
    }

    private int splitCustomRuleInts(String customRule, String requestedComponent) {
        String rule = customRule;
        ArrayList ruleParts = Lists.newArrayList((Iterable)Splitter.on((char)',').trimResults().split((CharSequence)rule));
        if (requestedComponent == "dimensionId") {
            return Integer.parseInt(ruleParts.get(0).toString());
        }
        if (requestedComponent == "spawnRate") {
            return Integer.parseInt(ruleParts.get(3).toString());
        }
        if (requestedComponent == "maxHeight") {
            return Integer.parseInt(ruleParts.get(4).toString());
        }
        if (requestedComponent == "minHeight") {
            return Integer.parseInt(ruleParts.get(5).toString());
        }
        if (requestedComponent == "veinSize") {
            return Integer.parseInt(ruleParts.get(6).toString());
        }
        return 0;
    }

    private Block splitCustomRuleBlocks(String customRule, String requestedComponent) {
        String rule = customRule;
        ArrayList ruleParts = Lists.newArrayList((Iterable)Splitter.on((char)',').trimResults().split((CharSequence)rule));
        ArrayList hostBlockInfo = Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)ruleParts.get(1).toString()));
        ArrayList spawningBlockInfo = Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)ruleParts.get(2).toString()));
        if (requestedComponent == "hostBlock") {
            Block hostBlock = (Block)Block.field_149771_c.func_82594_a(hostBlockInfo.get(0).toString());
            int meta = Integer.parseInt(hostBlockInfo.get(1).toString());
            ItemStack stack = new ItemStack(hostBlock, 1, meta);
            return Block.func_149634_a((Item)stack.func_77973_b());
        }
        if (requestedComponent == "spawningBlock") {
            Block spawningBlock = (Block)Block.field_149771_c.func_82594_a(spawningBlockInfo.get(0).toString());
            int meta = Integer.parseInt(spawningBlockInfo.get(1).toString());
            ItemStack stack = new ItemStack(spawningBlock, 1, meta);
            return Block.func_149634_a((Item)stack.func_77973_b());
        }
        return null;
    }
}

