/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generation;

import biomesoplenty.api.content.BOPCBlocks;
import biomesoplenty.common.world.features.WorldGenBOPBigMushroom;
import biomesoplenty.common.world.features.WorldGenBOPBlob;
import biomesoplenty.common.world.features.WorldGenBOPCoral;
import biomesoplenty.common.world.features.WorldGenBOPDoubleFlora;
import biomesoplenty.common.world.features.WorldGenBOPFlora;
import biomesoplenty.common.world.features.WorldGenBOPUndergroundDecoration;
import biomesoplenty.common.world.features.WorldGenCobwebNest;
import biomesoplenty.common.world.features.WorldGenGrassSplatter;
import biomesoplenty.common.world.features.WorldGenKelp;
import biomesoplenty.common.world.features.WorldGenLavaSpout;
import biomesoplenty.common.world.features.WorldGenLog;
import biomesoplenty.common.world.features.WorldGenLongVine;
import biomesoplenty.common.world.features.WorldGenRiverCane;
import biomesoplenty.common.world.features.WorldGenSandstoneSpike;
import biomesoplenty.common.world.features.WorldGenSplatter;
import biomesoplenty.common.world.features.WorldGenSplotches;
import biomesoplenty.common.world.features.WorldGenWasteland;
import biomesoplenty.common.world.features.WorldGenWasteland2;
import biomesoplenty.common.world.features.WorldGenWasteland3;
import biomesoplenty.common.world.features.WorldGenWasteland4;
import biomesoplenty.common.world.features.WorldGenWaterReeds;
import biomesoplenty.common.world.features.WorldGenWaterside;
import biomesoplenty.common.world.features.managers.WorldGenBOPFlowerManager;
import biomesoplenty.common.world.features.managers.WorldGenBOPGrassManager;
import biomesoplenty.common.world.features.nether.WorldGenBoneSpine;
import biomesoplenty.common.world.features.nether.WorldGenGrave;
import biomesoplenty.common.world.features.nether.WorldGenLakesNether;
import biomesoplenty.common.world.features.nether.WorldGenWaspHive;
import biomesoplenty.common.world.forcedgenerators.LakesForcedGenerator;
import biomesoplenty.common.world.forcedgenerators.MelonForcedGenerator;
import biomesoplenty.common.world.forcedgenerators.SpringForcedGenerator;
import biomesoplenty.common.world.generation.ForcedWorldFeatureBOP;
import biomesoplenty.common.world.generation.IBOPWorldGenerator;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenMelon;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenFieldAssociation {
    public static HashMap<String, WorldFeature> featureMap = new HashMap();

    public static void init() {
        WorldGenFieldAssociation.associateFeatures();
        WorldGenFieldAssociation.associateFeaturesForced();
    }

    private static void associateFeatures() {
        WorldGenFieldAssociation.associateFeature("generateQuicksand", new WorldGenSplotches(BOPCBlocks.mud, 1, 24, new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m}));
        WorldGenFieldAssociation.associateFeature("generateCanyon", new WorldGenSplotches(BOPCBlocks.rocks, 0, 48, Blocks.field_150348_b));
        WorldGenFieldAssociation.associateFeature("generateStoneInGrass", new WorldGenSplotches(Blocks.field_150348_b, 0, 32, new Block[]{Blocks.field_150349_c}));
        WorldGenFieldAssociation.associateFeature("generateStoneInGrass2", new WorldGenSplotches(Blocks.field_150348_b, 0, 48, new Block[]{Blocks.field_150349_c, Blocks.field_150346_d}));
        WorldGenFieldAssociation.associateFeature("generateGrass", new WorldGenSplotches((Block)Blocks.field_150349_c, 0, 48, BOPCBlocks.rocks));
        WorldGenFieldAssociation.associateFeature("generateSand", new WorldGenSplotches((Block)Blocks.field_150354_m, 0, 32, BOPCBlocks.rocks));
        WorldGenFieldAssociation.associateFeature("generateQuagmire", new WorldGenSplotches((Block)Blocks.field_150349_c, 0, 48, BOPCBlocks.mud));
        WorldGenFieldAssociation.associateFeature("generateAsh", new WorldGenSplotches(BOPCBlocks.ash, 0, 32, BOPCBlocks.ashStone, Blocks.field_150424_aL));
        WorldGenFieldAssociation.associateFeature("generateMycelium", new WorldGenSplotches((Block)Blocks.field_150391_bh, 0, 32, new Block[]{Blocks.field_150349_c}));
        WorldGenFieldAssociation.associateFeature("generateSponge", new WorldGenSplotches(Blocks.field_150360_v, 0, 24, new Block[]{Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n}));
        WorldGenFieldAssociation.associateFeature("mudPerChunk", new WorldGenWaterside(BOPCBlocks.mud, 7, new Block[]{Blocks.field_150346_d, Blocks.field_150349_c}));
        WorldGenFieldAssociation.associateFeature("riverCanePerChunk", new WorldGenRiverCane());
        WorldGenFieldAssociation.associateFeature("shrubsPerChunk", new WorldGenBOPFlora(BOPCBlocks.foliage, 9));
        WorldGenFieldAssociation.associateFeature("bushesPerChunk", new WorldGenBOPFlora(BOPCBlocks.foliage, 4));
        WorldGenFieldAssociation.associateFeature("cloverPatchesPerChunk", new WorldGenBOPFlora(BOPCBlocks.foliage, 13, 128));
        WorldGenFieldAssociation.associateFeature("leafPilesPerChunk", new WorldGenBOPFlora(BOPCBlocks.foliage, 14, 256));
        WorldGenFieldAssociation.associateFeature("deadLeafPilesPerChunk", new WorldGenBOPFlora(BOPCBlocks.foliage, 15, 256));
        WorldGenFieldAssociation.associateFeature("lavenderPerChunk", new WorldGenBOPFlora(BOPCBlocks.flowers2, 3));
        WorldGenFieldAssociation.associateFeature("thornsPerChunk", new WorldGenBOPFlora(BOPCBlocks.plants, 5));
        WorldGenFieldAssociation.associateFeature("stalagmitesPerChunk", new WorldGenBOPUndergroundDecoration(BOPCBlocks.stoneFormations, 0));
        WorldGenFieldAssociation.associateFeature("stalactitesPerChunk", new WorldGenBOPUndergroundDecoration(BOPCBlocks.stoneFormations, 1));
        WorldGenFieldAssociation.associateFeature("desertSproutsPerChunk", new WorldGenBOPFlora(BOPCBlocks.plants, 2));
        WorldGenFieldAssociation.associateFeature("bromeliadsPerChunk", new WorldGenBOPFlora(BOPCBlocks.flowers, 12));
        WorldGenFieldAssociation.associateFeature("waterReedsPerChunk", new WorldGenWaterReeds());
        WorldGenFieldAssociation.associateFeature("wildCarrotsPerChunk", new WorldGenBOPFlora(BOPCBlocks.plants, 11));
        WorldGenFieldAssociation.associateFeature("poisonIvyPerChunk", new WorldGenBOPFlora(BOPCBlocks.foliage, 7));
        WorldGenFieldAssociation.associateFeature("berryBushesPerChunk", new WorldGenBOPFlora(BOPCBlocks.foliage, 8));
        WorldGenFieldAssociation.associateFeature("portobellosPerChunk", new WorldGenBOPFlora(BOPCBlocks.mushrooms, 1));
        WorldGenFieldAssociation.associateFeature("koruPerChunk", new WorldGenBOPFlora(BOPCBlocks.foliage, 12));
        WorldGenFieldAssociation.associateFeature("toadstoolsPerChunk", new WorldGenBOPFlora(BOPCBlocks.mushrooms, 0));
        WorldGenFieldAssociation.associateFeature("blueMilksPerChunk", new WorldGenBOPFlora(BOPCBlocks.mushrooms, 2));
        WorldGenFieldAssociation.associateFeature("cattailsPerChunk", new WorldGenBOPFlora(BOPCBlocks.plants, 7));
        WorldGenFieldAssociation.associateFeature("highCattailsPerChunk", new WorldGenBOPDoubleFlora(BOPCBlocks.plants, BOPCBlocks.plants, 10, 9));
        WorldGenFieldAssociation.associateFeature("flaxPerChunk", new WorldGenBOPDoubleFlora(BOPCBlocks.foliage, BOPCBlocks.foliage, 3, 6, 24));
        WorldGenFieldAssociation.associateFeature("algaePerChunk", new WorldGenBOPFlora(BOPCBlocks.foliage, 0, 256));
        WorldGenFieldAssociation.associateFeature("sproutsPerChunk", new WorldGenBOPFlora(BOPCBlocks.foliage, 5));
        WorldGenFieldAssociation.associateFeature("tinyCactiPerChunk", new WorldGenBOPFlora(BOPCBlocks.plants, 12));
        WorldGenFieldAssociation.associateFeature("oasesPerChunk", new WorldGenWaterside((Block)Blocks.field_150349_c, 7, new Block[]{Blocks.field_150354_m, Blocks.field_150405_ch}));
        WorldGenFieldAssociation.associateFeature("minersDelightPerChunk", new WorldGenBOPUndergroundDecoration(BOPCBlocks.flowers2, 6));
        WorldGenFieldAssociation.associateFeature("rootsPerChunk", new WorldGenBOPFlora(BOPCBlocks.plants, 15));
        WorldGenFieldAssociation.associateFeature("grassSplatterPerChunk", new WorldGenGrassSplatter());
        WorldGenFieldAssociation.associateFeature("rockpilesPerChunk", new WorldGenBOPBlob(Blocks.field_150347_e, 0));
        WorldGenFieldAssociation.associateFeature("wastelandRockPilesPerChunk", new WorldGenBOPBlob(BOPCBlocks.driedDirt, 0));
        WorldGenFieldAssociation.associateFeature("logsPerChunk", new WorldGenLog());
        WorldGenFieldAssociation.associateFeature("lavaSpoutsPerChunk", new WorldGenLavaSpout());
        WorldGenFieldAssociation.associateFeature("cobwebsPerChunk", new WorldGenBOPFlora(Blocks.field_150321_G, 0));
        WorldGenFieldAssociation.associateFeature("cobwebNestsPerChunk", new WorldGenCobwebNest());
        WorldGenFieldAssociation.associateFeature("wasteland1PerChunk", new WorldGenWasteland());
        WorldGenFieldAssociation.associateFeature("wasteland2PerChunk", new WorldGenWasteland2());
        WorldGenFieldAssociation.associateFeature("wasteland3PerChunk", new WorldGenWasteland3());
        WorldGenFieldAssociation.associateFeature("wasteland4PerChunk", new WorldGenWasteland4());
        WorldGenFieldAssociation.associateFeature("smolderingGrassPerChunk", new WorldGenSplatter(BOPCBlocks.bopGrass, 1, BOPCBlocks.ash, Blocks.field_150424_aL));
        WorldGenFieldAssociation.associateFeature("sandSplatterPerChunk", new WorldGenSplatter((Block)Blocks.field_150354_m, new Block[]{Blocks.field_150349_c}));
        WorldGenFieldAssociation.associateFeature("gravelSplatterPerChunk", new WorldGenSplatter(Blocks.field_150351_n, new Block[]{Blocks.field_150349_c}));
        WorldGenFieldAssociation.associateFeature("redSandSplatterPerChunk", new WorldGenSplatter((Block)Blocks.field_150354_m, 1, BOPCBlocks.hardSand));
        WorldGenFieldAssociation.associateFeature("dirtSplatterPerChunk", new WorldGenSplatter(Blocks.field_150346_d, 1, new Block[]{Blocks.field_150349_c}));
        WorldGenFieldAssociation.associateFeature("sandstoneSpikesPerChunk", new WorldGenSandstoneSpike());
        WorldGenFieldAssociation.associateFeature("glowshroomsPerChunk", new WorldGenBOPFlora(BOPCBlocks.mushrooms, 3));
        WorldGenFieldAssociation.associateFeature("bopBigMushroomsPerChunk", new WorldGenBOPBigMushroom(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150391_bh, BOPCBlocks.overgrownNetherrack}));
        WorldGenFieldAssociation.associateFeature("seaweedPerChunk", new WorldGenBOPCoral(BOPCBlocks.coral2, 8, 256));
        WorldGenFieldAssociation.associateFeature("coralPerChunk", new WorldGenBOPCoral(BOPCBlocks.coral1, -1));
        WorldGenFieldAssociation.associateFeature("kelpPerChunk", new WorldGenKelp(4, 8));
        WorldGenFieldAssociation.associateFeature("kelpThickPerChunk", new WorldGenKelp(4, 8));
        WorldGenFieldAssociation.associateFeature("shortKelpPerChunk", new WorldGenKelp(2, 4));
        WorldGenFieldAssociation.associateFeature("waspHivesPerChunk", new WorldGenWaspHive());
        WorldGenFieldAssociation.associateFeature("boneSpinesUpPerChunk", new WorldGenBoneSpine(false));
        WorldGenFieldAssociation.associateFeature("boneSpinesDownPerChunk", new WorldGenBoneSpine(true));
        WorldGenFieldAssociation.associateFeature("netherLavaLakesPerChunk", new WorldGenLakesNether());
        WorldGenFieldAssociation.associateFeature("netherVinesPerChunk", new WorldGenLongVine(BOPCBlocks.ivy, 15, 45));
        WorldGenFieldAssociation.associateFeature("netherrackSplatterPerChunk", new WorldGenSplatter(Blocks.field_150424_aL, BOPCBlocks.overgrownNetherrack));
        WorldGenFieldAssociation.associateFeature("gravesPerChunk", new WorldGenGrave());
        WorldGenFieldAssociation.associateFeature("bopFlowersPerChunk", new WorldGenBOPFlowerManager());
        WorldGenFieldAssociation.associateFeature("bopGrassPerChunk", new WorldGenBOPGrassManager());
    }

    private static void associateFeaturesForced() {
        WorldGenFieldAssociation.associateFeatureForced("waterSpringsPerChunk", (WorldGenerator)new WorldGenLiquids((Block)Blocks.field_150358_i), SpringForcedGenerator.class);
        WorldGenFieldAssociation.associateFeatureForced("lavaSpringsPerChunk", (WorldGenerator)new WorldGenLiquids((Block)Blocks.field_150356_k), SpringForcedGenerator.class);
        WorldGenFieldAssociation.associateFeatureForced("waterLakesPerChunk", (WorldGenerator)new WorldGenLakes(Blocks.field_150355_j), LakesForcedGenerator.class);
        WorldGenFieldAssociation.associateFeatureForced("lavaLakesPerChunk", (WorldGenerator)new WorldGenLakes(Blocks.field_150353_l), LakesForcedGenerator.class);
        WorldGenFieldAssociation.associateFeatureForced("poisonLakesPerChunk", (WorldGenerator)new WorldGenLakes(BOPCBlocks.poison), LakesForcedGenerator.class);
        WorldGenFieldAssociation.associateFeatureForced("bloodLakesPerChunk", (WorldGenerator)new WorldGenLakes(BOPCBlocks.blood), LakesForcedGenerator.class);
        WorldGenFieldAssociation.associateFeatureForced("generateMelons", (WorldGenerator)new WorldGenMelon(), MelonForcedGenerator.class);
    }

    public static void associateFeature(String name, WorldFeature feature) {
        featureMap.put(name, feature);
    }

    public static void associateFeature(String name, WorldGenerator generator) {
        featureMap.put(name, new WorldFeature(generator));
    }

    public static void associateFeatureForced(String name, WorldGenerator generator, Class<? extends ForcedWorldFeatureBOP> forcedFeature) {
        WorldGenFieldAssociation.associateFeature(name, new WorldFeature(generator, forcedFeature));
    }

    public static WorldFeature getAssociatedFeature(String name) {
        return featureMap.get(name);
    }

    public static class WorldFeature {
        private WorldGenerator worldGenerator;
        private Class<? extends ForcedWorldFeatureBOP> forcedFeature;

        protected WorldFeature(WorldGenerator worldGenerator, Class<? extends ForcedWorldFeatureBOP> forcedFeature) {
            this.worldGenerator = worldGenerator;
            this.forcedFeature = forcedFeature;
        }

        protected WorldFeature(WorldGenerator worldGenerator) {
            this(worldGenerator, null);
        }

        public IBOPWorldGenerator getBOPWorldGenerator() {
            if (this.worldGenerator instanceof IBOPWorldGenerator) {
                return (IBOPWorldGenerator)this.worldGenerator;
            }
            if (this.forcedFeature != null) {
                try {
                    return this.forcedFeature.getConstructor(WorldGenerator.class).newInstance(this.worldGenerator);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

