/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.integration;

import biomesoplenty.api.content.BOPCBlocks;
import biomesoplenty.api.content.BOPCItems;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.FlowerManager;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;

public class ForestryIntegration {
    private static final String LIQUID_WATER = "water";
    private static final String LIQUID_BIOMASS = "biomass";
    private static final String LIQUID_JUICE = "juice";
    private static final String LIQUID_HONEY = "honey";
    private static final int MINER = 0;
    private static final int DIGGER = 1;
    private static final int FORESTER = 2;
    private static final Item mulch = GameRegistry.findItem((String)"Forestry", (String)"mulch");

    protected static void init() {
        ForestryIntegration.addFermenterRecipes();
        ForestryIntegration.addSqueezerRecipes();
        ForestryIntegration.addFlowers();
        ForestryIntegration.addBlocksToBackpack();
    }

    private static void addFermenterRecipes() {
        ForestryIntegration.addFermenterRecipe(new ItemStack(BOPCBlocks.saplings, 1, Short.MAX_VALUE), 250, LIQUID_BIOMASS);
        ForestryIntegration.addFermenterRecipe(new ItemStack(BOPCBlocks.colorizedSaplings, 1, Short.MAX_VALUE), 250, LIQUID_BIOMASS);
    }

    private static void addSqueezerRecipes() {
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(BOPCItems.food)}, FluidRegistry.getFluidStack((String)LIQUID_JUICE, (int)50), new ItemStack(mulch), 5);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(BOPCItems.food, 1, 8)}, FluidRegistry.getFluidStack((String)LIQUID_JUICE, (int)200), new ItemStack(mulch), 20);
    }

    private static void addFlowers() {
        FlowerManager.plainFlowers.add(new ItemStack(BOPCBlocks.flowers, 1, Short.MAX_VALUE));
        FlowerManager.plainFlowers.add(new ItemStack(BOPCBlocks.flowers2, 1, Short.MAX_VALUE));
    }

    private static void addBlocksToBackpack() {
        for (int i = 0; i < 16; ++i) {
            if (i % 2 != 0) continue;
            BackpackManager.backpackItems[0].add(new ItemStack(BOPCBlocks.gemOre, 1, i));
        }
        BackpackManager.backpackItems[0].add(new ItemStack(BOPCBlocks.driedDirt));
        BackpackManager.backpackItems[0].add(new ItemStack(BOPCBlocks.overgrownNetherrack));
        BackpackManager.backpackItems[0].add(new ItemStack(BOPCBlocks.cragRock));
        BackpackManager.backpackItems[0].add(new ItemStack(BOPCBlocks.ashStone));
        BackpackManager.backpackItems[0].add(new ItemStack(BOPCItems.gems, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[1].add(new ItemStack(BOPCBlocks.bopGrass, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[1].add(new ItemStack(BOPCBlocks.longGrass));
        BackpackManager.backpackItems[1].add(new ItemStack(BOPCBlocks.mud));
        BackpackManager.backpackItems[1].add(new ItemStack(BOPCBlocks.hardDirt));
        BackpackManager.backpackItems[1].add(new ItemStack(BOPCBlocks.hardSand));
        BackpackManager.backpackItems[1].add(new ItemStack(BOPCBlocks.originGrass));
        BackpackManager.backpackItems[1].add(new ItemStack(BOPCBlocks.ash));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.logs1, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.logs2, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.logs3, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.logs4, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.colorizedSaplings, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.saplings, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.leaves1, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.leaves2, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.leaves3, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.leaves4, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.colorizedLeaves1, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.colorizedLeaves2, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.appleLeaves, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.persimmonLeaves, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.bamboo, 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack(BOPCBlocks.petals, 1, Short.MAX_VALUE));
    }

    private static void addFermenterRecipe(ItemStack resource, int fermentationValue, String output) {
        RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.0f, FluidRegistry.getFluidStack((String)output, (int)1), FluidRegistry.getFluidStack((String)LIQUID_WATER, (int)1));
        if (FluidRegistry.isFluidRegistered((String)LIQUID_JUICE)) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, FluidRegistry.getFluidStack((String)output, (int)1), FluidRegistry.getFluidStack((String)LIQUID_JUICE, (int)1));
        }
        if (FluidRegistry.isFluidRegistered((String)LIQUID_HONEY)) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, FluidRegistry.getFluidStack((String)output, (int)1), FluidRegistry.getFluidStack((String)LIQUID_HONEY, (int)1));
        }
    }
}

