/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.blocks;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.content.BOPCBlocks;
import biomesoplenty.client.render.RenderUtils;
import biomesoplenty.common.utils.ISubLocalization;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBOPNewGrass
extends BlockGrass
implements ISubLocalization {
    private static final String[] grassTypes = new String[]{"loamy", "sandy", "silty"};
    private static final IIcon[] grassIcons = new IIcon[grassTypes.length * 2];

    public BlockBOPNewGrass() {
        this.func_149711_c(0.6f);
        this.setHarvestLevel("shovel", 0);
        this.func_149672_a(field_149779_h);
        this.func_149647_a(BiomesOPlenty.tabBiomesOPlenty);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K) {
            if (world.func_72957_l(x, y + 1, z) < 4 && world.getBlockLightOpacity(x, y + 1, z) > 2) {
                world.func_147465_d(x, y, z, BOPCBlocks.newBopDirt, world.func_72805_g(x, y, z) * 2, 2);
            } else if (world.func_72957_l(x, y + 1, z) >= 9) {
                for (int l = 0; l < 4; ++l) {
                    int randX = x + random.nextInt(3) - 1;
                    int randY = y + random.nextInt(5) - 3;
                    int randZ = z + random.nextInt(3) - 1;
                    Block block = world.func_147439_a(randX, randY + 1, randZ);
                    if (world.func_72957_l(randX, randY + 1, randZ) < 4 || world.getBlockLightOpacity(randX, randY + 1, randZ) > 2) continue;
                    if (world.func_147439_a(randX, randY, randZ) == Blocks.field_150346_d && world.func_72805_g(randX, randY, randZ) == 0) {
                        world.func_147449_b(randX, randY, randZ, (Block)Blocks.field_150349_c);
                        continue;
                    }
                    if (world.func_147439_a(randX, randY, randZ) != BOPCBlocks.newBopDirt) continue;
                    int dirtMeta = world.func_72805_g(randX, randY, randZ);
                    world.func_147465_d(randX, randY, randZ, BOPCBlocks.newBopGrass, (dirtMeta - (dirtMeta & 1)) / 2, 2);
                }
            }
        }
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        Block plant = plantable.getPlant(world, x, y + 1, z);
        EnumPlantType plantType = plantable.getPlantType(world, x, y + 1, z);
        switch (plantType) {
            case Cave: {
                return this.isSideSolid(world, x, y, z, ForgeDirection.UP);
            }
            case Plains: {
                return true;
            }
            case Beach: {
                boolean hasWater = world.func_147439_a(x - 1, y, z).func_149688_o() == Material.field_151586_h || world.func_147439_a(x + 1, y, z).func_149688_o() == Material.field_151586_h || world.func_147439_a(x, y, z - 1).func_149688_o() == Material.field_151586_h || world.func_147439_a(x, y, z + 1).func_149688_o() == Material.field_151586_h;
                return hasWater;
            }
        }
        return super.canSustainPlant(world, x, y, z, direction, plantable);
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        block0: for (int l = 0; l < 128; ++l) {
            int i1 = x;
            int j1 = y + 1;
            int k1 = z;
            for (int l1 = 0; l1 < l / 16; ++l1) {
                if (world.func_147439_a(i1 += random.nextInt(3) - 1, (j1 += (random.nextInt(3) - 1) * random.nextInt(3) / 2) - 1, k1 += random.nextInt(3) - 1) != BOPCBlocks.newBopGrass || world.func_147439_a(i1, j1, k1).func_149721_r()) continue block0;
            }
            if (world.func_147439_a(i1, j1, k1).func_149688_o() != Material.field_151579_a) continue;
            if (random.nextInt(8) != 0) {
                if (!Blocks.field_150329_H.func_149718_j(world, i1, j1, k1)) continue;
                world.func_147465_d(i1, j1, k1, (Block)Blocks.field_150329_H, 1, 3);
                continue;
            }
            world.func_72807_a(i1, k1).plantFlower(world, random, i1, j1, k1);
        }
    }

    public void onPlantGrow(World world, int x, int y, int z, int sourceX, int sourceY, int sourceZ) {
        world.func_147465_d(x, y, z, BOPCBlocks.newBopDirt, world.func_72805_g(x, y, z) * 2, 2);
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        return BOPCBlocks.newBopDirt.func_149650_a(metadata * 2, random, fortune);
    }

    public int func_149692_a(int metadata) {
        return metadata * 2;
    }

    @Override
    public String getUnlocalizedName(String baseName, ItemStack itemStack) {
        return baseName + "." + grassTypes[itemStack.func_77960_j()];
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RenderUtils.newGrassModel;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item block, CreativeTabs creativeTab, List blockList) {
        for (int i = 0; i < grassTypes.length; ++i) {
            blockList.add(new ItemStack(block, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        for (int i = 0; i < grassTypes.length; ++i) {
            String grassType = grassTypes[i];
            BlockBOPNewGrass.grassIcons[i * 2 + 0] = iconRegister.func_94245_a("biomesoplenty:grass_" + grassType + "_side");
            BlockBOPNewGrass.grassIcons[i * 2 + 1] = iconRegister.func_94245_a("biomesoplenty:grass_" + grassType + "_side_snowed");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 1 ? Blocks.field_150349_c.func_149691_a(side, meta) : (side == 0 ? BOPCBlocks.newBopDirt.func_149691_a(side, meta * 2) : grassIcons[2 * meta]);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (side == 0) {
            return BOPCBlocks.newBopDirt.func_149691_a(side, meta * 2);
        }
        if (side == 1) {
            return Blocks.field_150349_c.func_149673_e(world, x, y, z, side);
        }
        Material material = world.func_147439_a(x, y + 1, z).func_149688_o();
        return material != Material.field_151597_y && material != Material.field_151596_z ? grassIcons[2 * meta] : grassIcons[2 * meta + 1];
    }
}

