/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.secretroomsmod.network;

import com.github.abrarsyed.secretroomsmod.network.PacketBase;
import com.github.abrarsyed.secretroomsmod.network.PacketCamo;
import com.github.abrarsyed.secretroomsmod.network.PacketKey;
import com.github.abrarsyed.secretroomsmod.network.PacketShowToggle;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.lang.reflect.Constructor;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ChannelHandler.Sharable
public class PacketManager
extends FMLIndexedMessageToMessageCodec<PacketBase> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final PacketManager INSTANCE = new PacketManager();
    private static final EnumMap<Side, FMLEmbeddedChannel> channels = Maps.newEnumMap(Side.class);

    public static void init() {
        if (!channels.isEmpty()) {
            return;
        }
        INSTANCE.addDiscriminator(0, PacketCamo.class);
        INSTANCE.addDiscriminator(1, PacketShowToggle.class);
        INSTANCE.addDiscriminator(2, PacketKey.class);
        channels.putAll(NetworkRegistry.INSTANCE.newChannel("SecretRooms", new ChannelHandler[]{INSTANCE}));
    }

    public void encodeInto(ChannelHandlerContext ctx, PacketBase packet, ByteBuf target) throws Exception {
        ByteArrayDataOutput output = ByteStreams.newDataOutput();
        packet.encode(output);
        target.writeBytes(output.toByteArray());
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, PacketBase packet) {
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])source.array());
        input.skipBytes(1);
        packet.decode(input);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.actionClient(packet);
        } else {
            this.actionServer(ctx, packet);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void actionClient(PacketBase packet) {
        Minecraft mc = Minecraft.func_71410_x();
        packet.actionClient((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g);
    }

    private void actionServer(ChannelHandlerContext ctx, PacketBase packet) {
        EntityPlayerMP player = ((NetHandlerPlayServer)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get()).field_147369_b;
        packet.actionServer(player.field_70170_p, player);
    }

    public static void sendToServer(PacketBase packet) {
        channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        channels.get(Side.CLIENT).writeAndFlush((Object)packet);
    }

    public static void sendToPlayer(PacketBase packet, EntityPlayer player) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public static void sendToAllAround(PacketBase packet, NetworkRegistry.TargetPoint point) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public static void sendToDimension(PacketBase packet, int dimension) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimension);
        channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public static void sendToAll(PacketBase packet) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public static Packet toMcPacket(PacketBase packet) {
        return channels.get(FMLCommonHandler.instance().getEffectiveSide()).generatePacketFrom((Object)packet);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.log(Level.ERROR, "Error in packet handling!", cause);
        ctx.fireExceptionCaught(cause);
    }

    public FMLIndexedMessageToMessageCodec<PacketBase> addDiscriminator(int discriminator, Class<? extends PacketBase> type) {
        if (!PacketManager.hasEmptyContructor(type)) {
            LOGGER.log(Level.FATAL, type.getName() + "does not have an empty constructor!");
        }
        return super.addDiscriminator(discriminator, type);
    }

    private static boolean hasEmptyContructor(Class type) {
        try {
            for (Constructor<?> c : type.getConstructors()) {
                if (c.getParameterTypes().length != 0) continue;
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }
}

