/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.secretroomsmod.blocks;

import com.github.abrarsyed.secretroomsmod.blocks.BlockCamoFull;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCamoWire
extends BlockCamoFull {
    private boolean shouldPower = true;

    public BlockCamoWire() {
        super(Material.field_151594_q);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("secretroomsmod:CamoRedstone");
    }

    @Override
    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        if (world.field_72995_K) {
            return;
        }
        this.calcPower(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        if (world.field_72995_K) {
            return;
        }
        this.calcPower(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        super.func_149749_a(world, x, y, z, block, par6);
        if (world.field_72995_K) {
            return;
        }
        world.func_147459_d(x, y, z, (Block)this);
    }

    private void calcPower(World world, int x, int y, int z) {
        int oldPower = world.func_72805_g(x, y, z);
        BlockCamoWire.setRedstoneProvidePower(false);
        this.shouldPower = false;
        int nonWirePower = world.func_94572_D(x, y, z);
        this.shouldPower = true;
        BlockCamoWire.setRedstoneProvidePower(true);
        int power = this.getInputPower(world, x, y, z);
        if (nonWirePower > 0 && nonWirePower > power - 1) {
            power = nonWirePower;
        } else if (power > 0) {
            --power;
        }
        if (oldPower != power) {
            world.func_72921_c(x, y, z, power, 2);
            world.func_147459_d(x, y, z, (Block)this);
        }
    }

    private int getInputPower(World world, int x, int y, int z) {
        int[] powers = new int[6];
        int power = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            power = 0;
            int pX = dir.offsetX + x;
            int pY = dir.offsetY + y;
            int pZ = dir.offsetZ + z;
            if (world.func_147437_c(pX, pY, pZ)) continue;
            Block block = world.func_147439_a(pX, pY, pZ);
            if (block == Blocks.field_150488_af || block == this) {
                power = world.func_72805_g(pX, pY, pZ);
            } else if (block.func_149740_M()) {
                power = block.func_149736_g(world, pX, pY, pZ, dir.getOpposite().ordinal());
            } else if (block.func_149744_f()) {
                power = Math.max(block.func_149748_c((IBlockAccess)world, pX, pY, pZ, dir.getOpposite().ordinal()), block.func_149709_b((IBlockAccess)world, pX, pY, pZ, dir.getOpposite().ordinal()));
            }
            powers[dir.ordinal()] = power;
        }
        power = 0;
        for (int p : powers) {
            power = Math.max(power, p);
        }
        power = Math.max(power, world.func_94572_D(x, y, z));
        return power;
    }

    public static void setRedstoneProvidePower(boolean bool) {
        ObfuscationReflectionHelper.setPrivateValue(BlockRedstoneWire.class, (Object)Blocks.field_150488_af, (Object)bool, (int)0);
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149744_f() ? world.func_72805_g(x, y, z) : 0;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149748_c(world, x, y, z, side);
    }

    public boolean func_149744_f() {
        return this.shouldPower;
    }
}

