/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.secretroomsmod.network;

import com.github.abrarsyed.secretroomsmod.blocks.TileEntityCamo;
import com.github.abrarsyed.secretroomsmod.common.BlockHolder;
import com.github.abrarsyed.secretroomsmod.network.PacketBase;
import com.github.abrarsyed.secretroomsmod.network.PacketManager;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PacketCamo
extends PacketBase {
    public int x;
    public int y;
    public int z;
    public BlockHolder holder;
    public boolean[] sides = new boolean[6];

    public PacketCamo() {
    }

    public PacketCamo(TileEntityCamo entity) {
        this.holder = entity.getBlockHolder();
        this.x = entity.field_145851_c;
        this.y = entity.field_145848_d;
        this.z = entity.field_145849_e;
        this.sides = (boolean[])entity.isCamo.clone();
        if (this.holder == null) {
            throw new IllegalArgumentException("TileEntity data is NULL!");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        if (world == null) {
            return;
        }
        TileEntityCamo entity = (TileEntityCamo)world.func_147438_o(this.x, this.y, this.z);
        if (entity == null || this.holder == null) {
            return;
        }
        entity.setBlockHolder(this.holder);
        entity.isCamo = this.sides;
        world.func_147471_g(this.x, this.y, this.z);
    }

    @Override
    public void actionServer(World world, EntityPlayerMP player) {
        if (world == null) {
            return;
        }
        TileEntityCamo entity = (TileEntityCamo)world.func_147438_o(this.x, this.y, this.z);
        if (entity == null || this.holder == null) {
            return;
        }
        entity.setBlockHolder(this.holder);
        entity.isCamo = this.sides;
        PacketManager.sendToDimension(this, world.field_73011_w.field_76574_g);
    }

    @Override
    public void encode(ByteArrayDataOutput output) {
        output.writeInt(this.x);
        output.writeInt(this.y);
        output.writeInt(this.z);
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            this.holder.writeToNBT(nbt);
            CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)output);
        }
        catch (IOException e) {
            // empty catch block
        }
        for (int i = 0; i < 6; ++i) {
            output.writeBoolean(this.sides[i]);
        }
    }

    @Override
    public void decode(ByteArrayDataInput input) {
        this.x = input.readInt();
        this.y = input.readInt();
        this.z = input.readInt();
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74794_a((DataInput)input);
            this.holder = BlockHolder.buildFromNBT(nbt);
        }
        catch (IOException e) {
            // empty catch block
        }
        for (int i = 0; i < 6; ++i) {
            this.sides[i] = input.readBoolean();
        }
    }
}

