/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonElement;
import greymerk.roguelike.worldgen.BlockFactoryCheckers;
import greymerk.roguelike.worldgen.BlockJumble;
import greymerk.roguelike.worldgen.BlockStripes;
import greymerk.roguelike.worldgen.BlockWeightedRandom;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;

public enum BlockFactory {
    METABLOCK,
    WEIGHTED,
    CHECKERS,
    JUMBLE,
    STRIPES;


    public static IBlockFactory create(String type, JsonElement blockJson) throws Exception {
        switch (BlockFactory.valueOf(type)) {
            case METABLOCK: {
                return new MetaBlock(blockJson);
            }
            case WEIGHTED: {
                return new BlockWeightedRandom(blockJson);
            }
            case CHECKERS: {
                return new BlockFactoryCheckers(blockJson);
            }
            case JUMBLE: {
                return new BlockJumble(blockJson);
            }
            case STRIPES: {
                return new BlockStripes(blockJson);
            }
        }
        return null;
    }
}

