/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.segment.part;

import greymerk.roguelike.catacomb.segment.part.SegmentBase;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import net.minecraft.init.Blocks;

public class SegmentMossyArch
extends SegmentBase {
    private int stairType;
    private static final int SPRUCE = 1;
    private boolean spawnHoleSet = false;

    @Override
    protected void genWall(Cardinal wallDirection) {
        MetaBlock stair = this.theme.getSecondaryStair();
        stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.reverse(wallDirection), true));
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        Coord cursor = new Coord(this.x, this.y, this.z);
        cursor.add(wallDirection, 2);
        WorldGenPrimitive.setBlock(this.world, this.rand, cursor, air, true, true);
        cursor.add(Cardinal.UP, 1);
        WorldGenPrimitive.setBlock(this.world, this.rand, cursor, air, true, true);
        cursor.add(Cardinal.UP, 1);
        WorldGenPrimitive.setBlock(this.world, this.rand, cursor, stair, true, true);
        for (Cardinal orth : Cardinal.getOrthogonal(wallDirection)) {
            cursor = new Coord(this.x, this.y, this.z);
            cursor.add(orth, 1);
            cursor.add(wallDirection, 2);
            WorldGenPrimitive.setBlock(this.world, this.rand, cursor, this.theme.getSecondaryPillar(), true, true);
            cursor.add(Cardinal.UP, 1);
            WorldGenPrimitive.setBlock(this.world, this.rand, cursor, this.theme.getSecondaryPillar(), true, true);
            cursor.add(Cardinal.UP, 1);
            WorldGenPrimitive.setBlock(this.world, this.rand, cursor, this.theme.getSecondaryWall(), true, true);
            cursor.add(Cardinal.reverse(wallDirection), 1);
            WorldGenPrimitive.setBlock(this.world, this.rand, cursor, stair, true, true);
        }
        cursor = new Coord(this.x, this.y, this.z);
        cursor.add(wallDirection, 2);
        cursor.add(Cardinal.DOWN, 1);
        WorldGenPrimitive.setBlock(this.world, cursor, Blocks.field_150355_j);
        cursor = new Coord(this.x, this.y, this.z);
        cursor.add(Cardinal.UP, 3);
        cursor.add(wallDirection, 1);
        WorldGenPrimitive.setBlock(this.world, this.rand, cursor, new MetaBlock(Blocks.field_150395_bd, this.rand.nextInt(15)), true, true);
        if (!this.spawnHoleSet) {
            this.spawnHole();
            this.spawnHoleSet = true;
        }
    }

    private void spawnHole() {
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.x, this.y + 2, this.z, this.x, this.y + 5, this.z, new MetaBlock(Blocks.field_150350_a));
        WorldGenPrimitive.randomVines(this.world, this.rand, this.x, this.y + 3, this.z, this.x, this.y + 5, this.z);
        if (!this.world.func_147437_c(this.x, this.y + 6, this.z)) {
            WorldGenPrimitive.setBlock(this.world, this.x, this.y + 7, this.z, Blocks.field_150355_j);
        }
    }
}

