/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.segment.part;

import greymerk.roguelike.catacomb.Catacomb;
import greymerk.roguelike.catacomb.CatacombLevel;
import greymerk.roguelike.catacomb.segment.ISegment;
import greymerk.roguelike.catacomb.segment.part.SegmentArch;
import greymerk.roguelike.catacomb.segment.part.SegmentMossyArch;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.world.World;

public abstract class SegmentBase
implements ISegment {
    protected World world;
    protected Random rand;
    protected Cardinal corridorDirection;
    protected int x;
    protected int y;
    protected int z;
    protected Cardinal[] orth;
    ITheme theme;

    @Override
    public void generate(World world, Random rand, CatacombLevel level, Cardinal corridorDirection, ITheme theme, int x, int y, int z) {
        if (level.hasNearbyNode(x, z)) {
            return;
        }
        this.world = world;
        this.rand = rand;
        this.corridorDirection = corridorDirection;
        this.theme = theme;
        this.x = x;
        this.y = y;
        this.z = z;
        for (Cardinal wall : this.orth = Cardinal.getOrthogonal(corridorDirection)) {
            if (!this.isValidWall(wall)) continue;
            this.genWall(wall);
        }
        if (this instanceof SegmentArch || this instanceof SegmentMossyArch) {
            this.addSupport();
        }
    }

    protected abstract void genWall(Cardinal var1);

    protected boolean isValidWall(Cardinal wallDirection) {
        switch (wallDirection) {
            case NORTH: {
                if (this.world.func_147437_c(this.x - 1, this.y + 1, this.z - 2)) {
                    return false;
                }
                if (!this.world.func_147437_c(this.x + 1, this.y + 1, this.z - 2)) break;
                return false;
            }
            case SOUTH: {
                if (this.world.func_147437_c(this.x - 1, this.y + 1, this.z + 2)) {
                    return false;
                }
                if (!this.world.func_147437_c(this.x + 1, this.y + 1, this.z + 2)) break;
                return false;
            }
            case EAST: {
                if (this.world.func_147437_c(this.x + 2, this.y + 1, this.z - 1)) {
                    return false;
                }
                if (!this.world.func_147437_c(this.x + 2, this.y + 1, this.z + 1)) break;
                return false;
            }
            case WEST: {
                if (this.world.func_147437_c(this.x - 2, this.y + 1, this.z - 1)) {
                    return false;
                }
                if (!this.world.func_147437_c(this.x - 2, this.y + 1, this.z + 1)) break;
                return false;
            }
        }
        return true;
    }

    private void addSupport() {
        if (!this.world.func_147437_c(this.x, this.y - 2, this.z)) {
            return;
        }
        int level = Catacomb.getLevel(this.y);
        WorldGenPrimitive.fillDown(this.world, this.rand, this.x, this.y - 2, this.z, this.theme.getPrimaryPillar());
        MetaBlock stair = this.theme.getPrimaryStair();
        stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.WEST, true));
        WorldGenPrimitive.setBlock(this.world, this.x - 1, this.y - 2, this.z, stair);
        stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.EAST, true));
        WorldGenPrimitive.setBlock(this.world, this.x + 1, this.y - 2, this.z, stair);
        stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.SOUTH, true));
        WorldGenPrimitive.setBlock(this.world, this.x, this.y - 2, this.z + 1, stair);
        stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.NORTH, true));
        WorldGenPrimitive.setBlock(this.world, this.x, this.y - 2, this.z - 1, stair);
    }
}

