/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonsPrison
implements IDungeon {
    World world;
    Random rand;
    IBlockFactory blocks;
    IBlockFactory pillar;

    @Override
    public boolean generate(World inWorld, Random inRandom, ITheme theme, int inOriginX, int inOriginY, int inOriginZ) {
        this.world = inWorld;
        this.rand = inRandom;
        this.blocks = theme.getPrimaryWall();
        this.pillar = theme.getPrimaryPillar();
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        WorldGenPrimitive.fillRectSolid(inWorld, this.rand, inOriginX - 7, inOriginY, inOriginZ - 7, inOriginX + 7, inOriginY + 3, inOriginZ + 7, air);
        WorldGenPrimitive.fillRectHollow(this.world, this.rand, inOriginX - 8, inOriginY - 1, inOriginZ - 8, inOriginX + 8, inOriginY + 5, inOriginZ + 8, this.blocks, false, true);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inOriginX - 7, inOriginY + 3, inOriginZ - 2, inOriginX + 7, inOriginY + 3, inOriginZ - 2, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inOriginX - 7, inOriginY + 3, inOriginZ + 2, inOriginX + 7, inOriginY + 3, inOriginZ + 2, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inOriginX - 2, inOriginY + 3, inOriginZ - 7, inOriginX - 2, inOriginY + 3, inOriginZ + 7, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inOriginX + 2, inOriginY + 3, inOriginZ - 7, inOriginX + 2, inOriginY + 3, inOriginZ + 7, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inOriginX - 7, inOriginY + 4, inOriginZ - 1, inOriginX - 2, inOriginY + 4, inOriginZ + 1, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inOriginX + 2, inOriginY + 4, inOriginZ - 1, inOriginX + 7, inOriginY + 4, inOriginZ + 1, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inOriginX - 1, inOriginY + 4, inOriginZ - 7, inOriginX + 1, inOriginY + 4, inOriginZ - 2, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inOriginX - 1, inOriginY + 4, inOriginZ + 2, inOriginX + 1, inOriginY + 4, inOriginZ + 7, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inOriginX - 1, inOriginY + 4, inOriginZ - 1, inOriginX + 1, inOriginY + 4, inOriginZ + 1, this.blocks);
        this.createCell(inOriginX - 5, inOriginY, inOriginZ - 5);
        this.createCell(inOriginX - 5, inOriginY, inOriginZ + 5);
        this.createCell(inOriginX + 5, inOriginY, inOriginZ - 5);
        this.createCell(inOriginX + 5, inOriginY, inOriginZ + 5);
        return false;
    }

    private void createCell(int inX, int inY, int inZ) {
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 3, inY - 1, inZ - 3, inX + 3, inY - 1, inZ + 3, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, inY - 1, inZ - 1, inX + 1, inY - 1, inZ + 1, new MetaBlock(Blocks.field_150341_Y));
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, inY, inZ - 2, inX - 2, inY + 2, inZ - 2, this.pillar);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, inY, inZ + 2, inX - 2, inY + 2, inZ + 2, this.pillar);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 2, inY, inZ - 2, inX + 2, inY + 2, inZ - 2, this.pillar);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 2, inY, inZ + 2, inX + 2, inY + 2, inZ + 2, this.pillar);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 3, inY + 3, inZ - 3, inX + 3, inY + 6, inZ + 3, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, inY + 4, inZ - 2, inX + 1, inY + 4, inZ - 2, air);
        WorldGenPrimitive.setBlock(this.world, inX, inY + 4, inZ - 2, Blocks.field_150429_aA);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, inY + 4, inZ + 2, inX + 1, inY + 4, inZ + 2, air);
        WorldGenPrimitive.setBlock(this.world, inX, inY + 4, inZ + 2, Blocks.field_150429_aA);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, inY + 4, inZ - 1, inX - 2, inY + 4, inZ + 1, air);
        WorldGenPrimitive.setBlock(this.world, inX - 2, inY + 4, inZ, Blocks.field_150429_aA);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 2, inY + 4, inZ - 1, inX + 2, inY + 4, inZ + 1, air);
        WorldGenPrimitive.setBlock(this.world, inX + 2, inY + 4, inZ, Blocks.field_150429_aA);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX, inY + 3, inZ, inX, inY + 6, inZ, air);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, inY + 3, inZ - 1, inX - 1, inY + 6, inZ - 1, air);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, inY + 3, inZ + 1, inX - 1, inY + 6, inZ + 1, air);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 1, inY + 3, inZ - 1, inX + 1, inY + 6, inZ - 1, air);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 1, inY + 3, inZ + 1, inX + 1, inY + 6, inZ + 1, air);
        MetaBlock bars = new MetaBlock(Blocks.field_150411_aY);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, inY, inZ - 2, inX + 1, inY + 2, inZ - 2, bars);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX, inY, inZ - 2, inX, inY + 1, inZ - 2, air);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, inY, inZ + 2, inX + 1, inY + 2, inZ + 2, bars);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX, inY, inZ + 2, inX, inY + 1, inZ + 2, air);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, inY, inZ - 1, inX - 2, inY + 2, inZ + 1, bars);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, inY, inZ, inX - 2, inY + 1, inZ, air);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 2, inY, inZ - 1, inX + 2, inY + 2, inZ + 1, bars);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 2, inY, inZ, inX + 2, inY + 1, inZ, air);
        if (this.rand.nextBoolean()) {
            switch (this.rand.nextInt(4)) {
                case 0: {
                    Spawner.generate(this.world, this.rand, inX - 2, inY + 4, inZ - 2, Spawner.ZOMBIE);
                    break;
                }
                case 1: {
                    Spawner.generate(this.world, this.rand, inX - 2, inY + 4, inZ + 2, Spawner.ZOMBIE);
                    break;
                }
                case 2: {
                    Spawner.generate(this.world, this.rand, inX + 2, inY + 4, inZ - 2, Spawner.ZOMBIE);
                    break;
                }
                case 3: {
                    Spawner.generate(this.world, this.rand, inX + 2, inY + 4, inZ + 2, Spawner.ZOMBIE);
                }
            }
        }
        if (this.rand.nextBoolean()) {
            TreasureChest.generate(this.world, this.rand, inX, inY, inZ);
        }
    }

    @Override
    public int getSize() {
        return 10;
    }
}

