/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonsPit
implements IDungeon {
    World world;
    Random rand;
    int originX;
    int originY;
    int originZ;
    byte dungeonHeight = (byte)3;
    int dungeonLength = 2;
    int dungeonWidth = 2;
    int woolColor;
    int numChests;
    IBlockFactory blocks;

    @Override
    public boolean generate(World inWorld, Random inRandom, ITheme theme, int inOriginX, int inOriginY, int inOriginZ) {
        this.world = inWorld;
        this.rand = inRandom;
        this.originX = inOriginX;
        this.originY = inOriginY;
        this.originZ = inOriginZ;
        this.blocks = theme.getPrimaryWall();
        this.buildWalls();
        this.buildFloor();
        this.buildRoof();
        this.buildPit();
        for (int dir = 0; dir < 4; ++dir) {
            this.setTrap(dir);
        }
        ArrayList<Coord> space = new ArrayList<Coord>();
        space.add(new Coord(this.originX - 2, this.originY, this.originZ - 2));
        space.add(new Coord(this.originX - 2, this.originY, this.originZ + 2));
        space.add(new Coord(this.originX + 2, this.originY, this.originZ - 2));
        space.add(new Coord(this.originX + 2, this.originY, this.originZ + 2));
        TreasureChest.createChests(inWorld, inRandom, 1, space);
        return true;
    }

    protected void buildWalls() {
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockY = this.originY + this.dungeonHeight; blockY >= this.originY - 1; --blockY) {
                for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                    if (blockX == this.originX - this.dungeonLength - 1 || blockZ == this.originZ - this.dungeonWidth - 1 || blockX == this.originX + this.dungeonLength + 1 || blockZ == this.originZ + this.dungeonWidth + 1) {
                        if (blockY >= 0 && !this.world.func_147439_a(blockX, blockY - 1, blockZ).func_149688_o().func_76220_a()) {
                            WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, Blocks.field_150350_a);
                            continue;
                        }
                        if (!this.world.func_147439_a(blockX, blockY, blockZ).func_149688_o().func_76220_a()) continue;
                        this.blocks.setBlock(this.world, this.rand, blockX, blockY, blockZ);
                        continue;
                    }
                    WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, new MetaBlock(Blocks.field_150350_a));
                }
            }
        }
    }

    protected void buildFloor() {
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                this.blocks.setBlock(this.world, this.rand, blockX, this.originY - 1, blockZ);
            }
        }
    }

    protected void buildRoof() {
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                this.blocks.setBlock(this.world, this.rand, blockX, this.dungeonHeight + 1, blockZ);
            }
        }
    }

    private void buildPit() {
        for (int x = this.originX - 2; x <= this.originX + 2; ++x) {
            for (int z = this.originZ - 2; z <= this.originZ + 2; ++z) {
                for (int y = this.originY - 1; y > 0; --y) {
                    if (this.world.func_147439_a(x, y, z) == Blocks.field_150350_a || y < 0 + this.rand.nextInt(5) && this.world.func_147439_a(x, y, z) == Blocks.field_150357_h) continue;
                    if (x == this.originX - 2 || x == this.originX + 2 || z == this.originZ - 2 || z == this.originZ + 2) {
                        this.blocks.setBlock(this.world, this.rand, x, y, z, true, true);
                        continue;
                    }
                    if (y < 10) {
                        WorldGenPrimitive.setBlock(this.world, x, y, z, Blocks.field_150355_j);
                        continue;
                    }
                    WorldGenPrimitive.setBlock(this.world, x, y, z, Blocks.field_150350_a);
                }
            }
        }
    }

    private void setTrap(int dir) {
        switch (dir) {
            case 0: {
                for (int x = this.originX - 1; x <= this.originX + 1; ++x) {
                    for (int z = this.originZ + 6; z >= this.originZ + 3; --z) {
                        for (int y = this.originY - 2; y <= this.originY + 3; ++y) {
                            if (this.world.func_147439_a(x, y, z) != Blocks.field_150350_a) continue;
                            return;
                        }
                    }
                }
                WorldGenPrimitive.setBlock(this.world, this.originX, this.originY, this.originZ + 2, Blocks.field_150456_au);
                WorldGenPrimitive.setBlock(this.world, this.originX, this.originY - 1, this.originZ + 3, Blocks.field_150429_aA, 3, 2, true, true);
                WorldGenPrimitive.setBlock(this.world, this.originX, this.originY - 1, this.originZ + 4, (Block)Blocks.field_150488_af);
                WorldGenPrimitive.setBlock(this.world, this.originX, this.originY, this.originZ + 5, Blocks.field_150437_az, 5, 2, true, true);
                WorldGenPrimitive.setBlock(this.world, this.originX, this.originY + 1, this.originZ + 4, (Block)Blocks.field_150320_F, 2, 2, true, true);
                break;
            }
            case 1: {
                for (int x = this.originX - 6; x <= this.originX - 3; ++x) {
                    for (int z = this.originZ - 1; z <= this.originZ + 1; ++z) {
                        for (int y = this.originY - 2; y <= this.originY + 3; ++y) {
                            if (this.world.func_147439_a(x, y, z) != Blocks.field_150350_a) continue;
                            return;
                        }
                    }
                }
                WorldGenPrimitive.setBlock(this.world, this.originX - 2, this.originY, this.originZ, Blocks.field_150456_au);
                WorldGenPrimitive.setBlock(this.world, this.originX - 3, this.originY - 1, this.originZ, Blocks.field_150429_aA, 2, 2, true, true);
                WorldGenPrimitive.setBlock(this.world, this.originX - 4, this.originY - 1, this.originZ, (Block)Blocks.field_150488_af);
                WorldGenPrimitive.setBlock(this.world, this.originX - 5, this.originY, this.originZ, Blocks.field_150437_az, 5, 2, true, true);
                WorldGenPrimitive.setBlock(this.world, this.originX - 4, this.originY + 1, this.originZ, (Block)Blocks.field_150320_F, 5, 2, true, true);
                break;
            }
            case 2: {
                for (int x = this.originX - 1; x <= this.originX + 1; ++x) {
                    for (int z = this.originZ - 6; z <= this.originZ - 3; ++z) {
                        for (int y = this.originY - 2; y <= this.originY + 3; ++y) {
                            if (this.world.func_147439_a(x, y, z) != Blocks.field_150350_a) continue;
                            return;
                        }
                    }
                }
                WorldGenPrimitive.setBlock(this.world, this.originX, this.originY, this.originZ - 2, Blocks.field_150456_au);
                WorldGenPrimitive.setBlock(this.world, this.originX, this.originY - 1, this.originZ - 3, Blocks.field_150429_aA, 4, 2, true, true);
                WorldGenPrimitive.setBlock(this.world, this.originX, this.originY - 1, this.originZ - 4, (Block)Blocks.field_150488_af);
                WorldGenPrimitive.setBlock(this.world, this.originX, this.originY, this.originZ - 5, Blocks.field_150437_az, 5, 2, true, true);
                WorldGenPrimitive.setBlock(this.world, this.originX, this.originY + 1, this.originZ - 4, (Block)Blocks.field_150320_F, 3, 2, true, true);
                break;
            }
            case 3: {
                for (int x = this.originX + 6; x >= this.originX + 3; --x) {
                    for (int z = this.originZ - 1; z <= this.originZ + 1; ++z) {
                        for (int y = this.originY - 2; y <= this.originY + 3; ++y) {
                            if (this.world.func_147439_a(x, y, z) != Blocks.field_150350_a) continue;
                            return;
                        }
                    }
                }
                WorldGenPrimitive.setBlock(this.world, this.originX + 2, this.originY, this.originZ, Blocks.field_150456_au);
                WorldGenPrimitive.setBlock(this.world, this.originX + 3, this.originY - 1, this.originZ, Blocks.field_150429_aA, 1, 2, true, true);
                WorldGenPrimitive.setBlock(this.world, this.originX + 4, this.originY - 1, this.originZ, (Block)Blocks.field_150488_af);
                WorldGenPrimitive.setBlock(this.world, this.originX + 5, this.originY, this.originZ, Blocks.field_150437_az, 5, 2, true, true);
                WorldGenPrimitive.setBlock(this.world, this.originX + 4, this.originY + 1, this.originZ, (Block)Blocks.field_150320_F, 4, 2, true, true);
            }
        }
    }

    @Override
    public int getSize() {
        return 4;
    }
}

