/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonObsidian
implements IDungeon {
    @Override
    public boolean generate(World world, Random rand, ITheme theme, int x, int y, int z) {
        Cardinal[] orth;
        Coord end;
        Coord start;
        HashSet<Coord> spawners = new HashSet<Coord>();
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        MetaBlock obsidian = new MetaBlock(Blocks.field_150343_Z);
        MetaBlock brick = new MetaBlock(Blocks.field_150385_bj);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 10, y - 3, z - 10, x + 10, y + 3, z + 10, air);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 7, y + 6, z - 7, x + 7, y + 6, z + 7, obsidian);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 8, y + 5, z - 8, x + 8, y + 5, z + 8, obsidian);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 9, y + 4, z - 9, x + 9, y + 4, z + 9, obsidian);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y + 3, z - 1, x + 1, y + 5, z + 1, air);
        WorldGenPrimitive.setBlock(world, x, y + 5, z, obsidian);
        spawners.add(new Coord(x, y + 4, z));
        WorldGenPrimitive.fillRectSolid(world, rand, x - 10, y - 4, z - 10, x + 10, y - 4, z + 10, obsidian);
        for (Cardinal dir : Cardinal.directions) {
            for (Cardinal orth2 : Cardinal.getOrthogonal(dir)) {
                start = new Coord(x, y, z);
                start.add(Cardinal.UP, 3);
                start.add(dir, 3);
                start.add(orth2, 3);
                end = new Coord(start);
                end.add(Cardinal.UP, 2);
                end.add(dir, 2);
                end.add(orth2, 2);
                WorldGenPrimitive.fillRectSolid(world, rand, start, end, air, true, true);
                start = new Coord(x, y, z);
                start.add(dir, 3);
                start.add(Cardinal.UP, 3);
                end = new Coord(start);
                end.add(dir, 2);
                start.add(orth2, 1);
                end.add(Cardinal.UP, 2);
                WorldGenPrimitive.fillRectSolid(world, rand, start, end, air, true, true);
                Coord cursor = new Coord(x, y, z);
                cursor.add(Cardinal.UP, 4);
                cursor.add(dir, 4);
                spawners.add(new Coord(cursor));
                cursor.add(orth2, 4);
                spawners.add(new Coord(cursor));
                cursor = new Coord(x, y, z);
                cursor.add(Cardinal.UP, 5);
                cursor.add(dir, 4);
                WorldGenPrimitive.setBlock(world, rand, cursor, obsidian, true, true);
                cursor.add(orth2, 4);
                WorldGenPrimitive.setBlock(world, rand, cursor, obsidian, true, true);
            }
        }
        for (Cardinal dir : Cardinal.directions) {
            orth = Cardinal.getOrthogonal(dir);
            Coord start2 = new Coord(x, y, z);
            start2.add(dir, 10);
            Coord end2 = new Coord(start2);
            start2.add(orth[0], 9);
            end2.add(orth[1], 9);
            start2.add(Cardinal.DOWN, 4);
            end2.add(Cardinal.DOWN, 1);
            WorldGenPrimitive.fillRectSolid(world, rand, start2, end2, obsidian, true, true);
            start2.add(Cardinal.UP, 7);
            end2.add(Cardinal.UP, 4);
            WorldGenPrimitive.fillRectSolid(world, rand, start2, end2, obsidian, true, true);
            start2 = new Coord(x, y, z);
            start2.add(dir, 6);
            start2.add(Cardinal.UP, 3);
            end2 = new Coord(start2);
            start2.add(orth[0], 9);
            end2.add(orth[1], 9);
            WorldGenPrimitive.fillRectSolid(world, rand, start2, end2, obsidian, true, true);
            start2 = new Coord(x, y, z);
            start2.add(dir, 2);
            start2.add(Cardinal.UP, 3);
            end2 = new Coord(start2);
            start2.add(orth[0], 9);
            end2.add(orth[1], 9);
            WorldGenPrimitive.fillRectSolid(world, rand, start2, end2, obsidian, true, true);
            start2 = new Coord(x, y, z);
            start2.add(dir, 11);
            end2 = new Coord(start2);
            start2.add(Cardinal.DOWN, 3);
            end2.add(Cardinal.UP, 3);
            start2.add(orth[0], 11);
            end2.add(orth[1], 11);
            WorldGenPrimitive.fillRectSolid(world, rand, start2, end2, obsidian, false, true);
        }
        DungeonObsidian.outerPillars(world, rand, x, y, z);
        for (Cardinal dir : Cardinal.directions) {
            orth = Cardinal.getOrthogonal(dir);
            Coord start3 = new Coord(x, y, z);
            start3.add(Cardinal.DOWN, 1);
            Coord end3 = new Coord(start3);
            end3.add(Cardinal.DOWN, 3);
            start3.add(dir, 9);
            start3.add(orth[0], 1);
            end3.add(orth[1], 1);
            WorldGenPrimitive.fillRectSolid(world, rand, start3, end3, brick, true, true);
        }
        for (Cardinal dir : Cardinal.directions) {
            for (Cardinal orth2 : Cardinal.getOrthogonal(dir)) {
                start = new Coord(x, y, z);
                end = new Coord(start);
                start.add(dir, 9);
                start.add(orth2, 2);
                start.add(Cardinal.DOWN, 3);
                end.add(dir, 8);
                end.add(orth2, 9);
                end.add(Cardinal.DOWN, 2);
                WorldGenPrimitive.fillRectSolid(world, rand, start, end, brick, true, true);
                MetaBlock step = new MetaBlock(Blocks.field_150387_bl);
                Coord stepSpot = new Coord(x, y, z);
                stepSpot.add(dir, 8);
                stepSpot.add(Cardinal.DOWN, 1);
                stepSpot.add(orth2, 2);
                step.setMeta(WorldGenPrimitive.blockOrientation(orth2, false));
                WorldGenPrimitive.setBlock(world, rand, stepSpot, step, true, true);
                stepSpot.add(dir, 1);
                WorldGenPrimitive.setBlock(world, rand, stepSpot, step, true, true);
                step.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.reverse(dir), false));
                stepSpot = new Coord(x, y, z);
                stepSpot.add(Cardinal.DOWN, 2);
                stepSpot.add(dir, 7);
                stepSpot.add(orth2, 3);
                WorldGenPrimitive.setBlock(world, rand, stepSpot, step, true, true);
                stepSpot.add(orth2, 1);
                WorldGenPrimitive.setBlock(world, rand, stepSpot, step, true, true);
                stepSpot.add(Cardinal.DOWN, 1);
                stepSpot.add(Cardinal.reverse(dir), 1);
                WorldGenPrimitive.setBlock(world, rand, stepSpot, step, true, true);
                stepSpot.add(Cardinal.reverse(orth2), 1);
                WorldGenPrimitive.setBlock(world, rand, stepSpot, step, true, true);
                stepSpot.add(dir, 1);
                WorldGenPrimitive.setBlock(world, rand, stepSpot, brick, true, true);
                stepSpot.add(orth2, 1);
                WorldGenPrimitive.setBlock(world, rand, stepSpot, brick, true, true);
                Coord corner = new Coord(x, y, z);
                corner.add(dir, 7);
                corner.add(orth2, 7);
                corner.add(Cardinal.DOWN, 2);
                WorldGenPrimitive.setBlock(world, rand, corner, brick, true, true);
                corner.add(Cardinal.DOWN, 1);
                WorldGenPrimitive.setBlock(world, rand, corner, brick, true, true);
                corner = new Coord(x, y, z);
                corner.add(dir, 6);
                corner.add(orth2, 6);
                corner.add(Cardinal.DOWN, 1);
                spawners.add(new Coord(corner));
            }
        }
        for (Cardinal dir : Cardinal.directions) {
            for (Cardinal orth2 : Cardinal.getOrthogonal(dir)) {
                Coord cursor = new Coord(x, y, z);
                cursor.add(Cardinal.DOWN, 2);
                cursor.add(dir, 3);
                DungeonObsidian.lavaWindow(world, new Coord(cursor), orth2);
                cursor.add(dir, 2);
                DungeonObsidian.lavaWindow(world, new Coord(cursor), orth2);
                Coord chestPos = new Coord(x, y, z);
                chestPos.add(dir, 4);
                chestPos.add(orth2, 2);
                chestPos.add(Cardinal.DOWN, 3);
                TreasureChest.generate(world, rand, chestPos.getX(), chestPos.getY(), chestPos.getZ(), TreasureChest.ORE);
            }
        }
        DungeonObsidian.innerPillars(world, rand, x, y, z);
        for (Coord space : spawners) {
            Spawner.generate(world, rand, space.getX(), space.getY(), space.getZ());
        }
        return true;
    }

    @Override
    public int getSize() {
        return 10;
    }

    private static void outerPillars(World world, Random rand, int x, int y, int z) {
        for (Cardinal dir : Cardinal.directions) {
            for (Cardinal orth : Cardinal.getOrthogonal(dir)) {
                Coord pillarLocation = new Coord(x, y, z);
                pillarLocation.add(dir, 10);
                pillarLocation.add(orth, 2);
                DungeonObsidian.outerPillar(world, rand, pillarLocation, dir);
                pillarLocation.add(orth, 3);
                DungeonObsidian.outerPillar(world, rand, pillarLocation, dir);
                pillarLocation.add(orth, 3);
                DungeonObsidian.outerPillar(world, rand, pillarLocation, dir);
            }
        }
    }

    private static void outerPillar(World world, Random rand, Coord pillarLocation, Cardinal dir) {
        MetaBlock obsidian = new MetaBlock(Blocks.field_150343_Z);
        int x = pillarLocation.getX();
        int y = pillarLocation.getY();
        int z = pillarLocation.getZ();
        WorldGenPrimitive.fillRectSolid(world, rand, x, y - 2, z, x, y + 3, z, obsidian);
        Coord blockLocation = new Coord(x, y + 3, z);
        blockLocation.add(dir, 1);
        WorldGenPrimitive.setBlock(world, rand, blockLocation, obsidian, true, true);
        for (int i = 0; i < 3; ++i) {
            blockLocation.add(Cardinal.reverse(dir), 1);
            blockLocation.add(Cardinal.UP, 1);
            WorldGenPrimitive.setBlock(world, rand, blockLocation, obsidian, true, true);
        }
    }

    private static void innerPillars(World world, Random rand, int x, int y, int z) {
        MetaBlock obsidian = new MetaBlock(Blocks.field_150343_Z);
        for (Cardinal dir : Cardinal.directions) {
            for (Cardinal orth : Cardinal.getOrthogonal(dir)) {
                Coord pillar = new Coord(x, y, z);
                pillar.add(dir, 2);
                pillar.add(orth, 2);
                WorldGenPrimitive.fillRectSolid(world, rand, pillar.getX(), y - 4, pillar.getZ(), pillar.getX(), y + 4, pillar.getZ(), obsidian, true, true);
                pillar.add(dir, 4);
                WorldGenPrimitive.fillRectSolid(world, rand, pillar.getX(), y - 4, pillar.getZ(), pillar.getX(), y + 4, pillar.getZ(), obsidian, true, true);
                pillar.add(orth, 3);
                WorldGenPrimitive.fillRectSolid(world, rand, pillar.getX(), y - 4, pillar.getZ(), pillar.getX(), y + 4, pillar.getZ(), obsidian, true, true);
                Coord start = new Coord(x, y, z);
                start.add(Cardinal.DOWN, 1);
                start.add(orth, 2);
                start.add(dir, 2);
                Coord end = new Coord(start);
                end.add(dir, 5);
                WorldGenPrimitive.fillRectSolid(world, rand, start, end, obsidian, true, true);
                start = new Coord(x, y, z);
                start.add(Cardinal.DOWN, 1);
                start.add(dir, 7);
                start.add(orth, 5);
                WorldGenPrimitive.setBlock(world, rand, start, obsidian, true, true);
                start.add(Cardinal.DOWN, 1);
                end = new Coord(start);
                end.add(Cardinal.reverse(dir), 1);
                end.add(orth, 1);
                end.add(Cardinal.DOWN, 1);
                WorldGenPrimitive.fillRectSolid(world, rand, start, end, obsidian, true, true);
            }
        }
    }

    private static void lavaWindow(World world, Coord cursor, Cardinal orth) {
        WorldGenPrimitive.setBlock(world, cursor, Blocks.field_150353_l);
        cursor.add(Cardinal.DOWN, 1);
        WorldGenPrimitive.setBlock(world, cursor, Blocks.field_150353_l);
        cursor.add(orth, 1);
        WorldGenPrimitive.setBlock(world, cursor, Blocks.field_150353_l);
        cursor.add(Cardinal.UP, 1);
        WorldGenPrimitive.setBlock(world, cursor, Blocks.field_150353_l);
    }
}

