/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.treasure.TreasureChestBase;
import greymerk.roguelike.treasure.loot.provider.ItemFood;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;

public class DungeonAshlea
implements IDungeon {
    IBlockFactory plank;
    MetaBlock stairSpruce;
    IBlockFactory log;

    @Override
    public boolean generate(World world, Random rand, ITheme theme, int x, int y, int z) {
        this.plank = theme.getSecondaryWall();
        this.stairSpruce = theme.getSecondaryStair();
        this.log = theme.getSecondaryPillar();
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 6, y, z - 6, x + 6, y + 2, z + 6, air);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 6, y + 3, z - 6, x + 6, y + 4, z + 6, this.plank, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y + 3, z - 2, x + 4, y + 3, z - 2, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.SOUTH, true), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y + 3, z + 2, x + 4, y + 3, z + 2, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.NORTH, true), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 2, y + 3, z - 4, x - 2, y + 3, z + 4, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.EAST, true), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 2, y + 3, z - 4, x + 2, y + 3, z + 4, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.WEST, true), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y + 3, z - 4, x + 1, y + 3, z + 4, air);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y + 3, z - 1, x + 4, y + 3, z + 1, air);
        MetaBlock pinkClay = new MetaBlock(Blocks.field_150406_ce, 2);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 7, y - 1, z - 7, x + 7, y - 1, z + 7, pinkClay, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y - 1, z - 6, x + 1, y - 1, z + 6, this.log, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 5, y - 1, z - 1, x - 2, y - 1, z + 1, this.log, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 2, y - 1, z - 1, x + 5, y - 1, z + 1, this.log, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 7, y, z - 2, x + 7, y + 2, z + 6, this.plank, false, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 7, y, z - 6, x - 7, y + 2, z + 6, this.plank, false, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 6, y, z - 7, x + 2, y + 2, z - 7, this.plank, false, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 6, y, z + 7, x + 6, y + 2, z + 7, this.plank, false, true);
        int i = -6;
        while (i <= 6) {
            for (int j = -6; j <= 6; j += 4) {
                DungeonAshlea.pillar(world, rand, theme, x + i, y, z + j);
            }
            i += 4;
        }
        this.stove(world, rand, x + 4, y, z - 4);
        this.storage(world, rand, x + 4, y, z + 4);
        this.northTable(world, rand, x - 4, y, z - 4);
        this.southTable(world, rand, x - 4, y, z + 4);
        return true;
    }

    private void stove(World world, Random rand, int x, int y, int z) {
        MetaBlock brick = new MetaBlock(Blocks.field_150336_V);
        MetaBlock stair = new MetaBlock(Blocks.field_150389_bf);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y - 1, z - 4, x + 2, y - 1, z + 1, brick);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y, z - 4, x + 1, y + 2, z - 3, brick);
        WorldGenPrimitive.setBlock(world, rand, x - 1, y, z - 2, WorldGenPrimitive.blockOrientation(stair, Cardinal.EAST, false), true, true);
        WorldGenPrimitive.setBlock(world, rand, x - 1, y + 1, z - 2, WorldGenPrimitive.blockOrientation(stair, Cardinal.EAST, true), true, true);
        WorldGenPrimitive.setBlock(world, rand, x + 1, y, z - 2, WorldGenPrimitive.blockOrientation(stair, Cardinal.WEST, false), true, true);
        WorldGenPrimitive.setBlock(world, rand, x + 1, y + 1, z - 2, WorldGenPrimitive.blockOrientation(stair, Cardinal.WEST, true), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y + 2, z - 2, x + 1, y + 2, z - 2, brick);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y + 2, z - 1, x + 2, y + 2, z - 1, WorldGenPrimitive.blockOrientation(stair, Cardinal.SOUTH, true), true, true);
        WorldGenPrimitive.setBlock(world, x, y - 1, z - 3, Blocks.field_150424_aL);
        WorldGenPrimitive.setBlock(world, x, y, z - 3, (Block)Blocks.field_150480_ab);
        WorldGenPrimitive.setBlock(world, rand, x, y + 1, z - 3, WorldGenPrimitive.blockOrientation(stair, Cardinal.SOUTH, true), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 2, y, z - 1, x + 2, y + 2, z + 1, brick);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 1, y + 2, z - 1, x + 1, y + 2, z + 1, WorldGenPrimitive.blockOrientation(stair, Cardinal.WEST, true), true, true);
        WorldGenPrimitive.setBlock(world, x + 2, y, z, Blocks.field_150460_al);
        WorldGenPrimitive.setBlock(world, rand, x + 2, y + 1, z, WorldGenPrimitive.blockOrientation(stair, Cardinal.WEST, true), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y + 3, z - 1, x + 1, y + 3, z + 1, brick);
    }

    private void northTable(World world, Random rand, int x, int y, int z) {
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y - 1, z - 1, x + 1, y - 1, z + 1, this.plank, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y, z - 2, x + 1, y, z - 2, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.SOUTH, false), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 2, y, z - 1, x - 2, y, z + 1, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.EAST, false), true, true);
        WorldGenPrimitive.setBlock(world, rand, x, y, z, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.NORTH, true), true, true);
        WorldGenPrimitive.setBlock(world, rand, x + 1, y, z, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.EAST, true), true, true);
        WorldGenPrimitive.setBlock(world, rand, x + 1, y, z + 1, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.SOUTH, true), true, true);
        WorldGenPrimitive.setBlock(world, rand, x, y, z + 1, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.WEST, true), true, true);
        WorldGenPrimitive.setBlock(world, x, y + 1, z, Blocks.field_150478_aa);
    }

    private void southTable(World world, Random rand, int x, int y, int z) {
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y - 1, z - 1, x + 1, y - 1, z + 1, this.plank, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y, z + 2, x + 1, y, z + 2, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.NORTH, false), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 2, y, z - 1, x - 2, y, z + 1, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.EAST, false), true, true);
        WorldGenPrimitive.setBlock(world, rand, x, y, z - 1, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.NORTH, true), true, true);
        WorldGenPrimitive.setBlock(world, rand, x + 1, y, z - 1, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.EAST, true), true, true);
        WorldGenPrimitive.setBlock(world, rand, x + 1, y, z, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.SOUTH, true), true, true);
        WorldGenPrimitive.setBlock(world, rand, x, y, z, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.WEST, true), true, true);
        WorldGenPrimitive.setBlock(world, x, y + 1, z, Blocks.field_150478_aa);
    }

    private void storage(World world, Random rand, int x, int y, int z) {
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y - 1, z - 1, x + 1, y - 1, z + 1, this.plank, true, true);
        WorldGenPrimitive.setBlock(world, rand, x + 2, y, z - 1, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.SOUTH, true), true, true);
        WorldGenPrimitive.setBlock(world, rand, x + 2, y, z, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.WEST, true), true, true);
        WorldGenPrimitive.setBlock(world, rand, x + 2, y, z + 1, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.NORTH, true), true, true);
        new TreasureChestAshlea().generate(world, rand, x + 2, y + 1, z, 1, false);
        WorldGenPrimitive.setBlock(world, rand, x - 1, y, z + 2, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.EAST, true), true, true);
        WorldGenPrimitive.setBlock(world, rand, x, y, z + 2, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.NORTH, true), true, true);
        WorldGenPrimitive.setBlock(world, rand, x + 1, y, z + 2, WorldGenPrimitive.blockOrientation(this.stairSpruce, Cardinal.WEST, true), true, true);
        new TreasureChestAshlea().generate(world, rand, x, y + 1, z + 2, 1, false);
    }

    private static void pillar(World world, Random rand, ITheme theme, int x, int y, int z) {
        MetaBlock stair = theme.getSecondaryStair();
        IBlockFactory pillar = theme.getSecondaryPillar();
        IBlockFactory wall = theme.getSecondaryWall();
        WorldGenPrimitive.fillRectSolid(world, rand, x, y, z, x, y + 1, z, pillar, true, true);
        WorldGenPrimitive.setBlock(world, rand, x, y + 2, z, wall, true, true);
        WorldGenPrimitive.setBlock(world, rand, x + 1, y + 2, z, WorldGenPrimitive.blockOrientation(stair, Cardinal.EAST, true), true, true);
        WorldGenPrimitive.setBlock(world, rand, x - 1, y + 2, z, WorldGenPrimitive.blockOrientation(stair, Cardinal.WEST, true), true, true);
        WorldGenPrimitive.setBlock(world, rand, x, y + 2, z + 1, WorldGenPrimitive.blockOrientation(stair, Cardinal.SOUTH, true), true, true);
        WorldGenPrimitive.setBlock(world, rand, x, y + 2, z - 1, WorldGenPrimitive.blockOrientation(stair, Cardinal.NORTH, true), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y + 3, z - 1, x + 1, y + 3, z + 1, wall, true, true);
    }

    @Override
    public int getSize() {
        return 10;
    }

    private class TreasureChestAshlea
    extends TreasureChestBase {
        private TreasureChestAshlea() {
        }

        @Override
        protected void fillChest(TileEntityChest chest, int level) {
            int stacks = RogueConfig.getBoolean(RogueConfig.GENEROUS) ? chest.func_70302_i_() : 12;
            for (int i = 0; i < stacks; ++i) {
                if (this.rand.nextInt(10) >= 8) continue;
                ItemStack item = ItemFood.getDessert(this.rand);
                chest.func_70299_a(this.rand.nextInt(chest.func_70302_i_()), item);
            }
        }
    }
}

