/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import greymerk.roguelike.catacomb.dungeon.DungeonFactory;
import greymerk.roguelike.catacomb.dungeon.IDungeonFactory;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.catacomb.theme.Theme;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.BiomeGenBase;

public class DungeonCustomization {
    private static List<Customization> customizations = new ArrayList<Customization>();

    public static ITheme getTheme(BiomeGenBase biome, int level) {
        Customization c = DungeonCustomization.getCustomization(biome);
        if (c == null) {
            return null;
        }
        return c.getTheme(level);
    }

    public static IDungeonFactory getRooms(BiomeGenBase biome, int level) {
        Customization c = DungeonCustomization.getCustomization(biome);
        if (c == null) {
            return null;
        }
        return c.getRooms(level);
    }

    private static Customization getCustomization(BiomeGenBase biome) {
        for (Customization custom : customizations) {
            if (custom.global) {
                return custom;
            }
            if (!custom.match(biome.field_76791_y)) continue;
            return custom;
        }
        return null;
    }

    private static void init() throws Exception {
        String content;
        File configDir = new File("config");
        if (!configDir.exists()) {
            return;
        }
        File dungeonfile = new File("config/roguelike-theme.cfg");
        try {
            content = Files.toString((File)dungeonfile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e1) {
            return;
        }
        JsonParser jParser = new JsonParser();
        JsonObject root = (JsonObject)jParser.parse(content);
        JsonElement configs = root.get("DungeonConfig");
        JsonArray configArray = configs.getAsJsonArray();
        for (JsonElement confElement : configArray) {
            customizations.add(new Customization(confElement.getAsJsonObject()));
        }
    }

    static {
        try {
            DungeonCustomization.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Customization {
        private boolean global;
        private List<String> biomes = new ArrayList<String>();
        private List<ITheme> theme = new ArrayList<ITheme>();
        private List<IDungeonFactory> rooms = new ArrayList<IDungeonFactory>();

        public Customization(JsonObject json) throws Exception {
            for (int i = 0; i < 5; ++i) {
                this.theme.add(null);
                this.rooms.add(null);
            }
            if (json.get("biomes") instanceof JsonArray) {
                this.global = false;
                this.parseBiomes(json.get("biomes").getAsJsonArray());
            } else if (json.get("biomes").getAsString().equals("all")) {
                this.global = true;
            }
            if (json.has("levels")) {
                this.parseLevels(json.get("levels").getAsJsonObject());
            }
        }

        private void parseBiomes(JsonArray json) {
            for (JsonElement e : json) {
                this.biomes.add(e.getAsString());
            }
        }

        private void parseLevels(JsonObject json) throws Exception {
            int i;
            if (json.has("all")) {
                for (i = 0; i < 5; ++i) {
                    this.parseLevel(json.get("all").getAsJsonObject(), i);
                }
            }
            for (i = 0; i < 5; ++i) {
                String level = Integer.toString(i);
                if (!json.has(level)) continue;
                this.parseLevel(json.get(level).getAsJsonObject(), i);
            }
        }

        private void parseLevel(JsonObject json, int level) throws Exception {
            if (json.has("theme")) {
                JsonObject themeData = json.get("theme").getAsJsonObject();
                this.theme.set(level, Theme.create(themeData));
            }
            if (json.has("rooms")) {
                JsonArray roomData = json.get("rooms").getAsJsonArray();
                DungeonFactory dungeons = new DungeonFactory(roomData);
                this.rooms.set(level, dungeons);
            }
        }

        public boolean match(String name) {
            for (String s : this.biomes) {
                if (!name.equals(s)) continue;
                return true;
            }
            return false;
        }

        public ITheme getTheme(int level) {
            return this.theme.get(level);
        }

        public IDungeonFactory getRooms(int level) {
            return this.rooms.get(level);
        }
    }
}

