/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb;

import greymerk.roguelike.catacomb.CatacombLevel;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.BlockJumble;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class CatacombTunneler {
    private World world;
    private Random rand;
    private CatacombLevel level;
    private List<Coord> tunnel;
    private Cardinal dir;
    private int originX;
    private int originY;
    private int originZ;
    private boolean done;
    private int extend;
    private ITheme theme;

    public CatacombTunneler(World world, Random rand, CatacombLevel level, Cardinal direction, ITheme theme, int x, int y, int z) {
        this.world = world;
        this.rand = rand;
        this.level = level;
        this.dir = direction;
        this.theme = theme;
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.done = false;
        this.extend = CatacombLevel.SCATTER * 2;
        this.tunnel = new ArrayList<Coord>();
        this.tunnel.add(new Coord(x, y, z));
    }

    public void update() {
        if (this.level.full()) {
            return;
        }
        if (this.done) {
            return;
        }
        if (this.level.hasNearbyNode(this.originX, this.originZ, CatacombLevel.SCATTER)) {
            this.advance();
        } else if (this.rand.nextInt(this.extend) == 0) {
            this.level.spawnNode(this);
            this.done = true;
        } else {
            this.advance();
            --this.extend;
        }
    }

    public void advance() {
        Coord toAdd = new Coord(this.originX, this.originY, this.originZ);
        this.tunnel.add(new Coord(toAdd));
        toAdd.add(this.dir, 1);
        this.originX = toAdd.getX();
        this.originZ = toAdd.getZ();
    }

    public boolean isDone() {
        if (this.level.full()) {
            return true;
        }
        return this.done;
    }

    public Cardinal getDirection() {
        return this.dir;
    }

    public int getX() {
        return this.originX;
    }

    public int getY() {
        return this.originY;
    }

    public int getZ() {
        return this.originZ;
    }

    public void construct(World world) {
        if (this.tunnel.isEmpty()) {
            return;
        }
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        IBlockFactory wallBlocks = this.theme.getPrimaryWall();
        BlockJumble bridgeBlocks = new BlockJumble();
        bridgeBlocks.addBlock(wallBlocks);
        bridgeBlocks.addBlock(air);
        for (Coord location : this.tunnel) {
            int x = location.getX();
            int z = location.getZ();
            if (this.dir == Cardinal.NORTH || this.dir == Cardinal.SOUTH) {
                WorldGenPrimitive.fillRectSolid(world, this.rand, x - 1, this.originY, z, x + 1, this.originY + 2, z, air, false, true);
                WorldGenPrimitive.fillRectSolid(world, this.rand, x - 2, this.originY - 1, z, x + 2, this.originY + 4, z, wallBlocks, false, true);
                WorldGenPrimitive.fillRectSolid(world, this.rand, x - 1, this.originY - 1, z, x + 1, this.originY - 1, z, bridgeBlocks, true, false);
                continue;
            }
            WorldGenPrimitive.fillRectSolid(world, this.rand, x, this.originY, z - 1, x, this.originY + 2, z + 1, air, false, true);
            WorldGenPrimitive.fillRectSolid(world, this.rand, x, this.originY - 1, z - 2, x, this.originY + 4, z + 2, wallBlocks, false, true);
            WorldGenPrimitive.fillRectSolid(world, this.rand, x, this.originY - 1, z - 1, x, this.originY - 1, z + 1, bridgeBlocks, true, false);
        }
        Coord location = this.tunnel.get(this.tunnel.size() - 1);
        location.add(this.dir, 1);
        Coord start = new Coord(location);
        Cardinal[] orth = Cardinal.getOrthogonal(this.dir);
        start.add(orth[0], 2);
        start.add(Cardinal.UP, 2);
        Coord end = new Coord(location);
        end.add(orth[1], 2);
        end.add(Cardinal.DOWN, 2);
        WorldGenPrimitive.fillRectSolid(world, this.rand, start, end, wallBlocks, false, true);
    }

    public void addSegments(World world) {
        for (Coord location : this.tunnel) {
            this.theme.genSegment(world, this.rand, this.level, this.dir, location);
        }
    }
}

