/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.WeightedRandomLoot;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class CustomLoot {
    public static void parseLoot() {
        String content;
        File configDir = new File("config");
        if (!configDir.exists()) {
            return;
        }
        File lootfile = new File("config/roguelike-loot.cfg");
        try {
            content = Files.toString((File)lootfile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e1) {
            return;
        }
        JsonParser jParser = new JsonParser();
        JsonObject root = (JsonObject)jParser.parse(content);
        JsonElement lootChanges = root.get("CustomLoot");
        JsonArray changeList = lootChanges.getAsJsonArray();
        for (JsonElement change : changeList) {
            CustomLoot.parseEntry(change.getAsJsonObject());
        }
    }

    public static void parseEntry(JsonObject entry) {
        if (entry.has("clear")) {
            CustomLoot.clear(entry);
        }
        if (entry.has("add")) {
            CustomLoot.add(entry);
        }
        if (entry.has("addAll")) {
            CustomLoot.addAll(entry);
        }
    }

    public static void clear(JsonObject entry) {
        JsonElement typeData = entry.get("clear");
        String type = typeData.getAsString();
        Loot.clear(Loot.valueOf(type));
    }

    public static void add(JsonObject entry) {
        JsonObject item = entry.get("add").getAsJsonObject();
        String type = item.get("type").getAsString();
        int level = item.get("level").getAsInt();
        Loot.add(Loot.valueOf(type), new WeightedRandomLoot(item), level);
    }

    public static void addAll(JsonObject entry) {
        JsonObject item = entry.get("addAll").getAsJsonObject();
        String type = item.get("type").getAsString();
        Loot.addAllLevels(Loot.valueOf(type), new WeightedRandomLoot(item));
    }
}

