/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.config;

import greymerk.roguelike.config.ConfigFile;
import greymerk.roguelike.config.INIParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Tuple;

public enum RogueConfig {
    DONATURALSPAWN,
    LEVELRANGE,
    LEVELMAXROOMS,
    LEVELSCATTER,
    SPAWNFREQUENCY,
    GENEROUS,
    MOBDROPS,
    DIMENSION,
    PRECIOUSBLOCKS,
    LOOTING,
    OVERRIDELOOT;

    public static final String configDirName = "config";
    public static final String configFileName = "roguelike.cfg";
    private static ConfigFile instance;

    public static String getName(RogueConfig option) {
        switch (option) {
            case DONATURALSPAWN: {
                return "doNaturalSpawn";
            }
            case LEVELRANGE: {
                return "levelRange";
            }
            case LEVELMAXROOMS: {
                return "levelMaxRooms";
            }
            case LEVELSCATTER: {
                return "levelScatter";
            }
            case SPAWNFREQUENCY: {
                return "spawnFrequency";
            }
            case GENEROUS: {
                return "generous";
            }
            case DIMENSION: {
                return "dimension";
            }
            case PRECIOUSBLOCKS: {
                return "preciousBlocks";
            }
            case LOOTING: {
                return "looting";
            }
            case OVERRIDELOOT: {
                return "overrideLoot";
            }
        }
        return null;
    }

    public static Tuple getDefault(RogueConfig option) {
        switch (option) {
            case DONATURALSPAWN: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)true);
            }
            case LEVELRANGE: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)80);
            }
            case LEVELMAXROOMS: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)30);
            }
            case LEVELSCATTER: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)10);
            }
            case SPAWNFREQUENCY: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)10);
            }
            case GENEROUS: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)true);
            }
            case DIMENSION: {
                ArrayList<Integer> ints = new ArrayList<Integer>();
                ints.add(0);
                return new Tuple((Object)RogueConfig.getName(option), ints);
            }
            case PRECIOUSBLOCKS: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)true);
            }
            case LOOTING: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)0.085);
            }
            case OVERRIDELOOT: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)false);
            }
        }
        return null;
    }

    private static void setDefaults() {
        if (!instance.ContainsKey(RogueConfig.getName(DONATURALSPAWN))) {
            RogueConfig.setBoolean(DONATURALSPAWN, (Boolean)RogueConfig.getDefault(DONATURALSPAWN).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(LEVELRANGE))) {
            RogueConfig.setInt(LEVELRANGE, (Integer)RogueConfig.getDefault(LEVELRANGE).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(LEVELMAXROOMS))) {
            RogueConfig.setInt(LEVELMAXROOMS, (Integer)RogueConfig.getDefault(LEVELMAXROOMS).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(LEVELSCATTER))) {
            RogueConfig.setInt(LEVELSCATTER, (Integer)RogueConfig.getDefault(LEVELSCATTER).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(SPAWNFREQUENCY))) {
            RogueConfig.setInt(SPAWNFREQUENCY, (Integer)RogueConfig.getDefault(SPAWNFREQUENCY).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(GENEROUS))) {
            RogueConfig.setBoolean(GENEROUS, (Boolean)RogueConfig.getDefault(GENEROUS).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(DIMENSION))) {
            RogueConfig.setIntList(DIMENSION, (List)RogueConfig.getDefault(DIMENSION).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(PRECIOUSBLOCKS))) {
            RogueConfig.setBoolean(PRECIOUSBLOCKS, (Boolean)RogueConfig.getDefault(PRECIOUSBLOCKS).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(LOOTING))) {
            RogueConfig.setDouble(LOOTING, (Double)RogueConfig.getDefault(LOOTING).func_76340_b());
        }
    }

    public static double getDouble(RogueConfig option) {
        RogueConfig.reload(false);
        Tuple def = RogueConfig.getDefault(option);
        return instance.GetDouble(RogueConfig.getName(option), (Double)def.func_76340_b());
    }

    public static void setDouble(RogueConfig option, double value) {
        RogueConfig.reload(false);
        Tuple def = RogueConfig.getDefault(option);
        instance.Set(RogueConfig.getName(option), value);
    }

    public static boolean getBoolean(RogueConfig option) {
        RogueConfig.reload(false);
        Tuple def = RogueConfig.getDefault(option);
        return instance.GetBoolean(RogueConfig.getName(option), (Boolean)def.func_76340_b());
    }

    public static void setBoolean(RogueConfig option, Boolean value) {
        RogueConfig.reload(false);
        Tuple def = RogueConfig.getDefault(option);
        instance.Set(RogueConfig.getName(option), value);
    }

    public static int getInt(RogueConfig option) {
        RogueConfig.reload(false);
        Tuple def = RogueConfig.getDefault(option);
        return instance.GetInteger((String)def.func_76341_a(), (Integer)def.func_76340_b());
    }

    public static void setInt(RogueConfig option, int value) {
        RogueConfig.reload(false);
        Tuple def = RogueConfig.getDefault(option);
        instance.Set((String)def.func_76341_a(), value);
    }

    public static List<Integer> getIntList(RogueConfig option) {
        RogueConfig.reload(false);
        Tuple def = RogueConfig.getDefault(option);
        return instance.GetListInteger((String)def.func_76341_a(), (ArrayList)def.func_76340_b());
    }

    public static void setIntList(RogueConfig option, List<Integer> value) {
        RogueConfig.reload(false);
        Tuple def = RogueConfig.getDefault(option);
        instance.Set((String)def.func_76341_a(), value);
    }

    private static void init() {
        File cfile;
        File configDir = new File(configDirName);
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        if (!(cfile = new File("config/roguelike.cfg")).exists()) {
            try {
                cfile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            instance = new ConfigFile("config/roguelike.cfg", new INIParser());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RogueConfig.setDefaults();
        try {
            instance.Write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reload(boolean force) {
        if (instance == null || force) {
            RogueConfig.init();
        }
    }

    static {
        instance = null;
    }
}

