/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.theme;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.catacomb.segment.Segment;
import greymerk.roguelike.catacomb.theme.BlockSet;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.catacomb.theme.ThemeBase;
import greymerk.roguelike.catacomb.theme.ThemeBling;
import greymerk.roguelike.catacomb.theme.ThemeBrick;
import greymerk.roguelike.catacomb.theme.ThemeChecker;
import greymerk.roguelike.catacomb.theme.ThemeJungle;
import greymerk.roguelike.catacomb.theme.ThemeMossy;
import greymerk.roguelike.catacomb.theme.ThemeNether;
import greymerk.roguelike.catacomb.theme.ThemeOak;
import greymerk.roguelike.catacomb.theme.ThemeQuartz;
import greymerk.roguelike.catacomb.theme.ThemeRainbow;
import greymerk.roguelike.catacomb.theme.ThemeSandstone;
import greymerk.roguelike.catacomb.theme.ThemeSnow;
import greymerk.roguelike.catacomb.theme.ThemeSpruce;
import greymerk.roguelike.catacomb.theme.ThemeStone;
import java.util.ArrayList;
import net.minecraft.world.biome.BiomeGenBase;

public enum Theme {
    OAK,
    SPRUCE,
    STONE,
    MOSSY,
    NETHER,
    SANDSTONE,
    QUARTZ,
    BLING,
    CHECKER,
    RAINBOW,
    SNOW,
    JUNGLE,
    BRICK;


    public static ITheme getTheme(Theme type) {
        ThemeBase theme;
        switch (type) {
            case OAK: {
                theme = new ThemeOak();
                break;
            }
            case SPRUCE: {
                theme = new ThemeSpruce();
                break;
            }
            case STONE: {
                theme = new ThemeStone();
                break;
            }
            case MOSSY: {
                theme = new ThemeMossy();
                break;
            }
            case NETHER: {
                theme = new ThemeNether();
                break;
            }
            case SANDSTONE: {
                theme = new ThemeSandstone();
                break;
            }
            case QUARTZ: {
                theme = new ThemeQuartz();
                break;
            }
            case BLING: {
                theme = new ThemeBling();
                break;
            }
            case CHECKER: {
                theme = new ThemeChecker();
                break;
            }
            case RAINBOW: {
                theme = new ThemeRainbow();
                break;
            }
            case SNOW: {
                theme = new ThemeSnow();
                break;
            }
            case JUNGLE: {
                theme = new ThemeJungle();
                break;
            }
            case BRICK: {
                theme = new ThemeBrick();
                break;
            }
            default: {
                return null;
            }
        }
        return theme;
    }

    public static ITheme create(JsonObject json) throws Exception {
        JsonObject data;
        BlockSet primary = null;
        BlockSet secondary = null;
        ArrayList<Segment> segments = null;
        Segment arch = null;
        if (json.has("primary")) {
            data = json.get("primary").getAsJsonObject();
            primary = new BlockSet(data);
        }
        if (json.has("secondary")) {
            data = json.get("secondary").getAsJsonObject();
            secondary = new BlockSet(data);
        }
        if (json.has("segments")) {
            segments = new ArrayList<Segment>();
            data = json.get("segments").getAsJsonArray();
            for (JsonElement e : data) {
                segments.add(Segment.valueOf(e.getAsString()));
            }
        }
        if (json.has("arch")) {
            String s = json.get("arch").getAsString();
            arch = Segment.valueOf(s);
        }
        if (json.has("base")) {
            ITheme theme = Theme.getTheme(Theme.valueOf(json.get("base").getAsString()));
            return new ThemeBase((ThemeBase)theme, primary, secondary, segments, arch);
        }
        return new ThemeBase(primary, secondary, segments, arch);
    }

    public static ITheme getByLevel(BiomeGenBase biome, int level) {
        boolean hot = biome.field_76750_F >= 1.0f;
        boolean cold = biome.field_76750_F <= 0.1f;
        boolean wet = biome.field_76751_G >= 0.85f;
        boolean dry = (double)biome.field_76751_G <= 0.1;
        switch (level) {
            case 0: {
                if (cold) {
                    return Theme.getTheme(SPRUCE);
                }
                if (hot && dry) {
                    return Theme.getTheme(SANDSTONE);
                }
                if (hot && wet) {
                    return Theme.getTheme(JUNGLE);
                }
                return Theme.getTheme(OAK);
            }
            case 1: {
                if (hot && dry) {
                    return Theme.getTheme(SANDSTONE);
                }
                if (hot && wet) {
                    return Theme.getTheme(JUNGLE);
                }
                return Theme.getTheme(SPRUCE);
            }
            case 2: {
                if (hot && wet) {
                    return Theme.getTheme(MOSSY);
                }
                return Theme.getTheme(STONE);
            }
            case 3: {
                if (hot && dry) {
                    return Theme.getTheme(STONE);
                }
                return Theme.getTheme(MOSSY);
            }
            case 4: {
                return Theme.getTheme(NETHER);
            }
        }
        return null;
    }
}

