/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.segment.part;

import greymerk.roguelike.catacomb.segment.part.SegmentBase;
import greymerk.roguelike.worldgen.BlockWeightedRandom;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class SegmentMossyMushrooms
extends SegmentBase {
    private int stairType;
    private BlockWeightedRandom mushrooms;

    @Override
    protected void genWall(Cardinal wallDirection) {
        MetaBlock stair = this.theme.getSecondaryStair();
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        this.mushrooms = new BlockWeightedRandom();
        this.mushrooms.addBlock(new MetaBlock((Block)Blocks.field_150338_P), 3);
        this.mushrooms.addBlock(new MetaBlock((Block)Blocks.field_150337_Q), 3);
        this.mushrooms.addBlock(air, 10);
        Cardinal[] orth = Cardinal.getOrthogonal(wallDirection);
        Coord start = new Coord(this.x, this.y, this.z);
        start.add(wallDirection, 2);
        Coord end = new Coord(start);
        start.add(orth[0], 1);
        end.add(orth[1], 1);
        end.add(Cardinal.UP, 1);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, start, end, air, true, true);
        start.add(Cardinal.DOWN, 1);
        end.add(Cardinal.DOWN, 2);
        if (this.rand.nextInt(5) == 0) {
            WorldGenPrimitive.fillRectSolid(this.world, this.rand, start, end, new MetaBlock(Blocks.field_150355_j), true, true);
        } else {
            WorldGenPrimitive.fillRectSolid(this.world, this.rand, start, end, new MetaBlock((Block)Blocks.field_150391_bh), true, true);
            start.add(Cardinal.UP, 1);
            end.add(Cardinal.UP, 1);
            WorldGenPrimitive.fillRectSolid(this.world, this.rand, start, end, this.mushrooms, true, true);
        }
        for (Cardinal d : orth) {
            Coord cursor = new Coord(this.x, this.y, this.z);
            cursor.add(wallDirection, 2);
            cursor.add(d, 1);
            cursor.add(Cardinal.UP, 1);
            stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.reverse(d), true));
            WorldGenPrimitive.setBlock(this.world, this.rand, cursor, stair, true, true);
        }
    }
}

