/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.segment.part;

import greymerk.roguelike.catacomb.Catacomb;
import greymerk.roguelike.catacomb.segment.alcove.SilverfishNest;
import greymerk.roguelike.catacomb.segment.part.SegmentBase;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import net.minecraft.init.Blocks;

public class SegmentInset
extends SegmentBase {
    @Override
    protected void genWall(Cardinal wallDirection) {
        Coord cursor;
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        MetaBlock stair = this.theme.getSecondaryStair();
        Cardinal[] orth = Cardinal.getOrthogonal(wallDirection);
        Coord start = new Coord(this.x, this.y, this.z);
        start.add(wallDirection, 2);
        Coord end = new Coord(start);
        start.add(orth[0], 1);
        end.add(orth[1], 1);
        end.add(Cardinal.UP, 2);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, start, end, air, true, true);
        start.add(wallDirection, 1);
        end.add(wallDirection, 1);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, start, end, this.theme.getPrimaryWall(), true, true);
        for (Cardinal d : orth) {
            cursor = new Coord(this.x, this.y, this.z);
            cursor.add(Cardinal.UP, 2);
            cursor.add(wallDirection, 2);
            cursor.add(d, 1);
            stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.reverse(wallDirection), true));
            WorldGenPrimitive.setBlock(this.world, this.rand, cursor, stair, true, true);
            cursor = new Coord(this.x, this.y, this.z);
            cursor.add(wallDirection, 2);
            cursor.add(d, 1);
            stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.reverse(d), false));
            WorldGenPrimitive.setBlock(this.world, this.rand, cursor, stair, true, true);
        }
        cursor = new Coord(this.x, this.y, this.z);
        cursor.add(Cardinal.UP, 1);
        cursor.add(wallDirection, 3);
        WorldGenPrimitive.setBlock(this.world, this.rand, cursor, air, true, true);
        cursor.add(Cardinal.UP, 1);
        stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.reverse(wallDirection), true));
        WorldGenPrimitive.setBlock(this.world, this.rand, cursor, stair, true, true);
        this.bonus(this.x, this.y, this.z, wallDirection);
    }

    private void bonus(int x, int y, int z, Cardinal dir) {
        SilverfishNest nest;
        Coord shelf = new Coord(x, y, z);
        shelf.add(dir, 3);
        shelf.add(Cardinal.UP, 1);
        if (this.world.func_147437_c(shelf.getX(), shelf.getY() - 1, shelf.getZ())) {
            return;
        }
        if (this.rand.nextBoolean() && Catacomb.getLevel(y) == 0) {
            WorldGenPrimitive.setBlock(this.world, shelf.getX(), shelf.getY(), shelf.getZ(), Blocks.field_150457_bL, this.rand.nextInt(11) + 1, 2, true, true);
            return;
        }
        if (this.rand.nextInt(5) != 0) {
            return;
        }
        if (Catacomb.getLevel(y) == 3 && this.rand.nextBoolean() && (nest = new SilverfishNest()).isValidLocation(this.world, x, y, z, dir)) {
            nest.generate(this.world, this.rand, this.theme, x, y, z, dir);
            return;
        }
        if (this.rand.nextBoolean()) {
            if (Catacomb.getLevel(y) == 1) {
                WorldGenPrimitive.setBlock(this.world, shelf.getX(), shelf.getY(), shelf.getZ(), Blocks.field_150342_X);
                return;
            }
            if (Catacomb.getLevel(y) == 2 || Catacomb.getLevel(y) == 3) {
                WorldGenPrimitive.skull(this.world, this.rand, shelf.getX(), shelf.getY(), shelf.getZ(), Cardinal.reverse(dir));
                return;
            }
        }
        if (this.rand.nextBoolean()) {
            boolean trapped = Catacomb.getLevel(y) == 3 && this.rand.nextInt(3) == 0;
            TreasureChest.generate(this.world, this.rand, shelf.getX(), shelf.getY(), shelf.getZ(), Catacomb.getLevel(y), trapped);
            if (trapped) {
                WorldGenPrimitive.setBlock(this.world, shelf.getX(), shelf.getY() - 2, shelf.getZ(), Blocks.field_150335_W);
                if (this.rand.nextBoolean()) {
                    WorldGenPrimitive.setBlock(this.world, shelf.getX(), shelf.getY() - 3, shelf.getZ(), Blocks.field_150335_W);
                }
            }
        }
        if (Catacomb.getLevel(y) > 0) {
            Spawner.generate(this.world, this.rand, shelf.getX(), shelf.getY(), shelf.getZ());
            return;
        }
    }
}

