/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

public class DungeonsSmithy
implements IDungeon {
    World world;
    Random rand;
    int originX;
    int originY;
    int originZ;
    byte dungeonHeight = (byte)4;
    int dungeonLength = 2;
    int dungeonWidth = 2;
    int woolColor;
    int numChests = 0;
    int floorBlock;
    int wallBlock;

    @Override
    public boolean generate(World inWorld, Random inRandom, ITheme theme, int inOriginX, int inOriginY, int inOriginZ) {
        this.world = inWorld;
        this.rand = inRandom;
        this.originX = inOriginX;
        this.originY = inOriginY;
        this.originZ = inOriginZ;
        WorldGenPrimitive.fillRectSolid(this.world, inRandom, this.originX - 2, this.originY, this.originZ - 2, this.originX + 2, this.originY + 4, this.originZ + 2, new MetaBlock(Blocks.field_150350_a));
        this.buildWalls();
        this.buildFloor();
        this.buildRoof();
        MetaBlock anvil = new MetaBlock(Blocks.field_150467_bQ, RogueConfig.getBoolean(RogueConfig.GENEROUS) ? 0 : 8);
        WorldGenPrimitive.setBlock(this.world, inOriginX, inOriginY, inOriginZ, anvil);
        ArrayList<Coord> space = new ArrayList<Coord>();
        space.add(new Coord(this.originX - 2, this.originY, this.originZ - 2));
        space.add(new Coord(this.originX - 2, this.originY, this.originZ + 2));
        space.add(new Coord(this.originX + 2, this.originY, this.originZ - 2));
        space.add(new Coord(this.originX + 2, this.originY, this.originZ + 2));
        TreasureChest.generate(inWorld, this.rand, space, TreasureChest.SMITH);
        return true;
    }

    protected void buildRoof() {
        List<Coord> walls = WorldGenPrimitive.getRectHollow(this.originX - this.dungeonLength - 1, this.originY + this.dungeonHeight + 1, this.originZ - this.dungeonWidth - 1, this.originX + this.dungeonLength + 1, this.originY + this.dungeonHeight + 1, this.originZ + this.dungeonWidth + 1);
        for (Coord block : walls) {
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            WorldGenPrimitive.setBlock(this.world, x, y, z, Blocks.field_150417_aV, this.rand.nextInt(3), 2, false, true);
        }
    }

    protected void buildFloor() {
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, this.originX - this.dungeonLength - 1, this.originY - 1, this.originZ - this.dungeonWidth - 1, this.originX + this.dungeonLength + 1, this.originY - 1, this.originZ + this.dungeonWidth + 1, new MetaBlock(Blocks.field_150336_V));
    }

    protected void buildWalls() {
        List<Coord> walls = WorldGenPrimitive.getRectHollow(this.originX - this.dungeonLength - 1, this.originY - 1, this.originZ - this.dungeonWidth - 1, this.originX + this.dungeonLength + 1, this.originY + this.dungeonHeight, this.originZ + this.dungeonWidth + 1);
        for (Coord block : walls) {
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            Block blockID = Blocks.field_150347_e;
            if (this.rand.nextInt(300) == 0) {
                blockID = Blocks.field_150339_S;
            }
            if (this.rand.nextInt(5) == 0) {
                blockID = Blocks.field_150411_aY;
            }
            if (y == this.originY + this.dungeonHeight) {
                blockID = Blocks.field_150417_aV;
            }
            if (y == this.originY && (z == this.originZ || x == this.originX)) {
                blockID = Blocks.field_150426_aN;
            }
            if (!(y != this.originY + 1 || z != this.originZ && x != this.originX || this.world.func_147437_c(x, y, z))) {
                blockID = Blocks.field_150460_al;
                if (!WorldGenPrimitive.setBlock(this.world, x, y, z, blockID)) continue;
                TileEntityFurnace furnace = (TileEntityFurnace)this.world.func_147438_o(x, y, z);
                ItemStack coal = new ItemStack(Items.field_151044_h, 5 + this.rand.nextInt(10));
                furnace.func_70299_a(1, coal);
                continue;
            }
            WorldGenPrimitive.setBlock(this.world, x, y, z, blockID, 0, 2, false, true);
        }
    }

    @Override
    public int getSize() {
        return 5;
    }
}

