/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb;

import greymerk.roguelike.catacomb.CatacombNode;
import greymerk.roguelike.catacomb.CatacombTunneler;
import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.dungeon.IDungeonFactory;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class CatacombLevel {
    public static int SCATTER = 12;
    private World world;
    private Random rand;
    private CatacombNode start;
    private CatacombNode end;
    private List<CatacombNode> nodes;
    private int originX;
    private int originY;
    private int originZ;
    private boolean done;
    private int maxNodes;
    private int range;
    private IDungeonFactory rooms;
    private ITheme theme;

    public CatacombLevel(World world, Random rand, IDungeonFactory rooms, ITheme theme, int originX, int originY, int originZ) {
        this.world = world;
        this.nodes = new ArrayList<CatacombNode>();
        this.rand = rand;
        this.rooms = rooms;
        this.theme = theme;
        this.originX = originX;
        this.originY = originY;
        this.originZ = originZ;
        SCATTER = RogueConfig.getInt(RogueConfig.LEVELSCATTER);
        this.maxNodes = RogueConfig.getInt(RogueConfig.LEVELMAXROOMS);
        this.range = RogueConfig.getInt(RogueConfig.LEVELRANGE);
        this.start = new CatacombNode(world, rand, this, theme, originX, originY, originZ);
        this.nodes.add(this.start);
    }

    public CatacombLevel(World world, Random rand, IDungeonFactory rooms, ITheme theme, int originX, int originY, int originZ, int maxNodes, int range) {
        this.world = world;
        this.nodes = new ArrayList<CatacombNode>();
        this.rand = rand;
        this.rooms = rooms;
        this.theme = theme;
        this.originX = originX;
        this.originY = originY;
        this.originZ = originZ;
        SCATTER = RogueConfig.getInt(RogueConfig.LEVELSCATTER);
        this.maxNodes = maxNodes;
        this.range = range;
        this.start = new CatacombNode(world, rand, this, theme, originX, originY, originZ);
        this.nodes.add(this.start);
    }

    public void generate() {
        for (CatacombNode node : this.nodes) {
            node.construct(this.world);
        }
        Collections.shuffle(this.nodes, this.rand);
        for (CatacombNode node : this.nodes) {
            int x = node.getX();
            int y = node.getY();
            int z = node.getZ();
            if (node == this.end || node == this.start) continue;
            IDungeon toGenerate = this.rooms.get(this.rand);
            node.setDungeon(toGenerate);
            toGenerate.generate(this.world, this.rand, this.theme, x, y, z);
        }
        for (CatacombNode node : this.nodes) {
            node.segments();
        }
        this.generateLevelLink(this.world, this.rand, this.start.getX(), this.start.getY(), this.start.getZ());
    }

    private void generateLevelLink(World world, Random rand, int originX, int originY, int originZ) {
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        WorldGenPrimitive.fillRectSolid(world, rand, originX - 3, originY, originZ - 3, originX + 3, originY + 15, originZ + 3, air, true, true);
        List<Coord> shell = WorldGenPrimitive.getRectHollow(originX - 4, originY - 1, originZ - 4, originX + 4, originY + 16, originZ + 4);
        IBlockFactory blocks = this.theme.getPrimaryWall();
        for (Coord block : shell) {
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            if (y == originY - 1 || y == originY + 26) {
                blocks.setBlock(world, rand, x, y, z, true, true);
            }
            if (world.func_147437_c(x, y, z) && y < originY + 9) {
                WorldGenPrimitive.setBlock(world, x, y, z, Blocks.field_150411_aY);
                continue;
            }
            blocks.setBlock(world, rand, x, y, z, false, true);
        }
        WorldGenPrimitive.fillRectHollow(world, rand, originX - 4, originY + 9, originZ - 4, originX + 4, originY + 9, originZ + 4, blocks, true, true);
        MetaBlock stair = this.theme.getPrimaryStair();
        IBlockFactory fill = this.theme.getPrimaryWall();
        for (int y = originY; y <= originY + 9; ++y) {
            WorldGenPrimitive.spiralStairStep(world, rand, originX, y, originZ, stair, this.theme.getPrimaryPillar());
        }
    }

    public void update() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            this.nodes.get(i).update();
        }
        if (this.end == null) {
            boolean done = true;
            for (CatacombNode node : this.nodes) {
                if (node.isDone()) continue;
                done = false;
            }
            if (done) {
                CatacombNode choice;
                int attempts = 0;
                while ((choice = this.nodes.get(this.rand.nextInt(this.nodes.size()))) == this.start || this.distance(choice, this.start) > 16 + ++attempts * 2) {
                }
                this.end = choice;
                this.done = true;
            }
        }
    }

    public CatacombNode getEnd() {
        return this.end;
    }

    public void spawnNode(CatacombTunneler tunneler) {
        CatacombNode toAdd = new CatacombNode(this.world, this.rand, this, this.theme, tunneler);
        this.nodes.add(toAdd);
    }

    public boolean inRange(int x, int z) {
        int zrel;
        if (this.nodes.size() == 0) {
            return true;
        }
        int xrel = Math.abs(this.originX - x);
        int dist = (int)Math.sqrt(xrel * xrel + (zrel = Math.abs(this.originZ - z)) * zrel);
        return dist < this.range;
    }

    public int distance(CatacombNode aNode, CatacombNode other) {
        int xrel = Math.abs(aNode.getX() - other.getX());
        int zrel = Math.abs(aNode.getZ() - other.getZ());
        int dist = (int)Math.sqrt(xrel * xrel + zrel * zrel);
        return dist;
    }

    public boolean hasNearbyNode(int x, int z, int min) {
        for (CatacombNode node : this.nodes) {
            int zrel;
            int otherX = node.getX();
            int otherZ = node.getZ();
            int xrel = Math.abs(otherX - x);
            int dist = (int)Math.sqrt(xrel * xrel + (zrel = Math.abs(otherZ - z)) * zrel);
            if (dist >= min) continue;
            return true;
        }
        return false;
    }

    public boolean hasNearbyNode(int x, int z) {
        for (CatacombNode node : this.nodes) {
            int zrel;
            int otherX = node.getX();
            int otherZ = node.getZ();
            int xrel = Math.abs(otherX - x);
            int dist = (int)Math.sqrt(xrel * xrel + (zrel = Math.abs(otherZ - z)) * zrel);
            if (dist >= node.getSize()) continue;
            return true;
        }
        return false;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean full() {
        return this.nodes.size() >= this.maxNodes;
    }

    public int nodeCount() {
        return this.nodes.size();
    }
}

