/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class MetaBlock
implements IBlockFactory {
    private Block block;
    private int meta;
    private int flag;

    public MetaBlock(Block block) {
        this(block, 0, 2);
    }

    public MetaBlock(Block block, int meta) {
        this(block, meta, 2);
    }

    public MetaBlock(Block block, int meta, int flag) {
        this.block = block;
        this.meta = meta;
        this.flag = flag;
    }

    public MetaBlock(JsonElement data) throws Exception {
        JsonObject json = (JsonObject)data;
        if (!json.has("id")) {
            throw new Exception("MetaBlock JSON requires an id field");
        }
        this.block = Block.func_149684_b((String)json.get("id").getAsString());
        this.meta = json.has("meta") ? json.get("meta").getAsInt() : 0;
        this.flag = json.has("flag") ? json.get("flag").getAsInt() : 2;
    }

    public MetaBlock(MetaBlock toCopy) {
        this.block = toCopy.block;
        this.meta = toCopy.meta;
        this.flag = toCopy.flag;
    }

    public Block getBlockID() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setBlockID(Block in) {
        this.block = in;
    }

    public void setMeta(int in) {
        this.meta = in;
    }

    public void setFlag(int in) {
        this.flag = in;
    }

    public boolean setBlock(World world, Coord coord) {
        return this.setBlock(world, coord.getX(), coord.getY(), coord.getZ());
    }

    public boolean setBlock(World world, int x, int y, int z) {
        return WorldGenPrimitive.setBlock(world, x, y, z, this);
    }

    @Override
    public void setBlock(World world, Random rand, int x, int y, int z) {
        WorldGenPrimitive.setBlock(world, x, y, z, this.block, this.meta, this.flag, true, true);
    }

    @Override
    public void setBlock(World world, Random rand, int x, int y, int z, boolean fillAir, boolean replaceSolid) {
        WorldGenPrimitive.setBlock(world, x, y, z, this.block, this.meta, this.flag, fillAir, replaceSolid);
    }
}

